/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import java.awt.Color;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GLContext;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.region.MinimapChunk;
import xaero.common.minimap.render.MinimapRenderer;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.minimap.write.MinimapWriter;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;

public class MinimapFBORenderer
extends MinimapRenderer {
    private ImprovedFramebuffer scalingFramebuffer;
    private ImprovedFramebuffer rotationFramebuffer;
    private boolean triedFBO;
    private boolean loadedFBO;

    public MinimapFBORenderer(IXaeroMinimap modMain, Minecraft mc, WaypointsGuiRenderer waypointsGuiRenderer) {
        super(modMain, mc, waypointsGuiRenderer);
    }

    public void loadFrameBuffer() {
        if (!(GLContext.getCapabilities().GL_EXT_framebuffer_object || GLContext.getCapabilities().GL_ARB_framebuffer_object || GLContext.getCapabilities().OpenGL30)) {
            System.out.println("FBO not supported! Using minimap safe mode.");
        } else {
            if (!Minecraft.func_71410_x().field_71474_y.field_151448_g) {
                Minecraft.func_71410_x().field_71474_y.func_74306_a(GameSettings.Options.FBO_ENABLE, 0);
                System.out.println("FBO is supported but off. Turning it on.");
            }
            this.scalingFramebuffer = new ImprovedFramebuffer(512, 512, false);
            this.rotationFramebuffer = new ImprovedFramebuffer(512, 512, false);
            this.loadedFBO = this.scalingFramebuffer.field_147616_f != -1 && this.rotationFramebuffer.field_147616_f != -1;
        }
        this.triedFBO = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderChunks(MinimapProcessor minimap, int[] mapAndBuffer, int mapW, float sizeFix, float partial, int lightLevel, boolean useWorldMap) {
        MinimapWriter minimapWriter = MinimapProcessor.instance.getMinimapWriter();
        synchronized (minimapWriter) {
            this.renderChunksToFBO(minimap, (EntityPlayer)this.mc.field_71439_g, mapAndBuffer[1], mapW, sizeFix, partial, lightLevel, true, useWorldMap);
        }
        Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        GL11.glViewport((int)0, (int)0, (int)Minecraft.func_71410_x().func_147110_a().field_147621_c, (int)Minecraft.func_71410_x().func_147110_a().field_147618_d);
        this.rotationFramebuffer.func_147612_c();
    }

    public void renderChunksToFBO(MinimapProcessor minimap, EntityPlayer player, int bufferSize, int viewW, float sizeFix, float partial, int level, boolean retryIfError, boolean useWorldMap) {
        double zInsidePixel;
        int radius = (int)((double)viewW / Math.sqrt(2.0) / 2.0 / this.zoom) / 64 + 1;
        double playerX = minimap.getEntityRadar().getEntityX((Entity)player, partial);
        double playerZ = minimap.getEntityRadar().getEntityZ((Entity)player, partial);
        int xFloored = OptimizedMath.myFloor(playerX);
        int zFloored = OptimizedMath.myFloor(playerZ);
        int playerChunkX = xFloored >> 6;
        int playerChunkZ = zFloored >> 6;
        int offsetX = xFloored & 0x3F;
        int offsetZ = zFloored & 0x3F;
        boolean zooming = (double)((int)this.zoom) != this.zoom;
        this.scalingFramebuffer.func_147610_a(true);
        GL11.glClear((int)16640);
        GL11.glEnable((int)3553);
        RenderHelper.func_74518_a();
        long before = System.currentTimeMillis();
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)512.0, (double)512.0, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        before = System.currentTimeMillis();
        double xInsidePixel = minimap.getEntityRadar().getEntityX((Entity)player, partial) - (double)xFloored;
        if (xInsidePixel < 0.0) {
            xInsidePixel += 1.0;
        }
        if ((zInsidePixel = minimap.getEntityRadar().getEntityZ((Entity)player, partial) - (double)zFloored) < 0.0) {
            zInsidePixel += 1.0;
        }
        zInsidePixel = 1.0 - zInsidePixel;
        float halfWView = (float)viewW / 2.0f;
        float angle = (float)(90.0 - this.getRenderAngle(player));
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)256.0f, (float)256.0f, (float)-2000.0f);
        GL11.glScaled((double)this.zoom, (double)this.zoom, (double)1.0);
        if (useWorldMap) {
            this.modMain.getSupportMods().worldmapSupport.drawMinimap(this.helper, xFloored, zFloored, radius, zooming, this.zoom);
        } else if (MinimapProcessor.instance.getMinimapWriter().getLoadedBlocks() != null) {
            Gui.func_73734_a((int)-256, (int)-256, (int)256, (int)256, (int)black.hashCode());
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int minX = playerChunkX - radius - 1;
            int minZ = playerChunkZ - radius - 1;
            int maxX = playerChunkX + radius + 1;
            int maxZ = playerChunkZ + radius + 1;
            for (int X = minX; X <= maxX; ++X) {
                int canvasX = X - MinimapProcessor.instance.getMinimapWriter().getLoadedMapChunkX();
                if (canvasX < 0 || canvasX >= MinimapProcessor.instance.getMinimapWriter().getLoadedBlocks().length) continue;
                for (int Z = minZ; Z <= maxZ; ++Z) {
                    MinimapChunk mchunk;
                    int canvasZ = Z - MinimapProcessor.instance.getMinimapWriter().getLoadedMapChunkZ();
                    if (canvasZ < 0 || canvasZ >= MinimapProcessor.instance.getMinimapWriter().getLoadedBlocks().length || (mchunk = MinimapProcessor.instance.getMinimapWriter().getLoadedBlocks()[canvasX][canvasZ]) == null) continue;
                    mchunk.bindTexture(level);
                    if (!mchunk.isHasSomething() || level >= mchunk.getLevelsBuffered() || mchunk.getGlTexture(level) == 0) continue;
                    if (!zooming) {
                        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    } else {
                        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    }
                    int drawX = (mchunk.getX() - playerChunkX) * 64 - offsetX;
                    int drawZ = (mchunk.getZ() - playerChunkZ) * 64 - offsetZ - 1;
                    GL11.glEnable((int)3042);
                    GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
                    this.helper.drawMyTexturedModalRect(drawX, drawZ, 0, 0, 64.0f, 64.0f, 64.0f);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    if (this.modMain.getSettings().chunkGrid > -1) {
                        int grid = ModSettings.COLORS[this.modMain.getSettings().chunkGrid];
                        r = grid >> 16 & 0xFF;
                        g = grid >> 8 & 0xFF;
                        b = grid & 0xFF;
                    }
                    for (int t = 0; t < 16; ++t) {
                        if (mchunk.getTile(t % 4, t / 4) == null) continue;
                        if (this.modMain.getSettings().getSlimeChunks() && mchunk.getTile(t % 4, t / 4).isSlimeChunk()) {
                            int slimeDrawX = drawX + 16 * (t % 4);
                            int slimeDrawZ = drawZ + 16 * (t / 4);
                            this.helper.drawRect1710(slimeDrawX, slimeDrawZ, slimeDrawX + 16, slimeDrawZ + 16, slime.hashCode());
                        }
                        if (this.modMain.getSettings().chunkGrid <= -1 || !mchunk.getTile(t % 4, t / 4).isChunkGrid()) continue;
                        int gridDrawX = drawX + 16 * (t % 4);
                        int gridDrawZ = drawZ + 16 * (t / 4);
                        this.helper.drawRect1710(gridDrawX, gridDrawZ, gridDrawX + 16, gridDrawZ + 16, new Color(r, g, b, 64).hashCode());
                    }
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        }
        this.scalingFramebuffer.func_147609_e();
        this.rotationFramebuffer.func_147610_a(false);
        GL11.glClear((int)16640);
        this.scalingFramebuffer.func_147612_c();
        GL11.glLoadIdentity();
        if (this.modMain.getSettings().getAntiAliasing()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        GL11.glTranslatef((float)(halfWView + 0.5f), (float)(511.5f - halfWView), (float)-2000.0f);
        if (!this.modMain.getSettings().getLockNorth()) {
            GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-xInsidePixel * this.zoom), (double)(-zInsidePixel * this.zoom), (double)0.0);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.modMain.getSettings().minimapOpacity / 100.0f));
        this.helper.drawMyTexturedModalRect(-256.0f, -256.0f, 0, 0, 512.0f, 512.0f, 512.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        before = System.currentTimeMillis();
        this.mc.func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
        if (this.modMain.getSettings().getSmoothDots()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        GL11.glEnable((int)3042);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        EntityPlayer p = player;
        this.renderEntityListToFBO(minimap, p, MinimapProcessor.instance.getEntityRadar().getEntitiesIterator(), angle, playerX, playerZ, partial);
        this.renderEntityListToFBO(minimap, p, MinimapProcessor.instance.getEntityRadar().getItemsIterator(), angle, playerX, playerZ, partial);
        this.renderEntityListToFBO(minimap, p, MinimapProcessor.instance.getEntityRadar().getLivingIterator(), angle, playerX, playerZ, partial);
        this.renderEntityListToFBO(minimap, p, MinimapProcessor.instance.getEntityRadar().getHostileIterator(), angle, playerX, playerZ, partial);
        this.renderEntityListToFBO(minimap, p, MinimapProcessor.instance.getEntityRadar().getPlayersIterator(), angle, playerX, playerZ, partial);
        this.mc.func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
        if (!this.modMain.getSettings().alwaysArrow) {
            this.renderEntityDotToFBO(minimap, p, (Entity)p, angle, playerX, playerZ, partial);
        }
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        this.rotationFramebuffer.func_147609_e();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
    }

    public void renderEntityListToFBO(MinimapProcessor minimap, EntityPlayer p, Iterator<Entity> iter, float angle, double playerX, double playerZ, float partial) {
        while (iter.hasNext()) {
            Entity e = iter.next();
            if (p == e) continue;
            if ((Keyboard.isKeyDown((int)15) || this.modMain.getSettings().getPlayerHeads()) && e instanceof AbstractClientPlayer) {
                this.renderPlayerHeadToFBO(minimap, p, (AbstractClientPlayer)e, angle, playerX, playerZ, partial);
                continue;
            }
            this.renderEntityDotToFBO(minimap, p, e, angle, playerX, playerZ, partial);
        }
    }

    public void renderPlayerHeadToFBO(MinimapProcessor minimap, EntityPlayer mainPlayer, AbstractClientPlayer e, float angle, double playerX, double playerZ, float partial) {
        if (!minimap.getEntityRadar().shouldRenderEntity((Entity)e)) {
            return;
        }
        double offx = minimap.getEntityRadar().getEntityX((Entity)e, partial) - playerX;
        double offz = playerZ - minimap.getEntityRadar().getEntityZ((Entity)e, partial);
        double offh = mainPlayer.field_70163_u - e.field_70163_u;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(offx * this.zoom), (double)(offz * this.zoom), (double)0.0);
        if (!this.modMain.getSettings().getLockNorth()) {
            GL11.glRotatef((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glScaled((double)2.0, (double)2.0, (double)1.0);
        double brightness = minimap.getEntityRadar().getEntityBrightness(offh);
        GL11.glColor3d((double)brightness, (double)brightness, (double)brightness);
        boolean flag1 = e != null && e.func_152122_n() && (e.func_146103_bH().getName().equals("Dinnerbone") || e.func_146103_bH().getName().equals("Grumm"));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(e.func_110306_p());
        int l2 = 8 + (flag1 ? 8 : 0);
        int i3 = 8 * (flag1 ? -1 : 1);
        Gui.func_152125_a((int)-4, (int)-4, (float)8.0f, (float)((float)l2 + (float)i3), (int)8, (int)(-i3), (int)8, (int)8, (float)64.0f, (float)32.0f);
        if (this.modMain.getSettings().isPlayerNames()) {
            GL11.glPushMatrix();
            GL11.glScalef((float)0.5f, (float)-0.5f, (float)1.0f);
            GL11.glDisable((int)2884);
            this.mc.field_71466_p.func_85187_a(e.getDisplayName(), -this.mc.field_71466_p.func_78256_a(e.getDisplayName()) / 2, 11, -1, true);
            GL11.glPopMatrix();
        }
        if (e != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(e.func_110306_p());
            int j3 = 8 + (flag1 ? 8 : 0);
            int k3 = 8 * (flag1 ? -1 : 1);
            Gui.func_152125_a((int)-4, (int)-4, (float)40.0f, (float)((float)j3 + (float)k3), (int)8, (int)(-k3), (int)8, (int)8, (float)64.0f, (float)32.0f);
        }
        GL11.glPopMatrix();
    }

    public void renderEntityDotToFBO(MinimapProcessor minimap, EntityPlayer p, Entity e, float angle, double playerX, double playerZ, float partial) {
        if (!minimap.getEntityRadar().shouldRenderEntity(e)) {
            return;
        }
        double offx = minimap.getEntityRadar().getEntityX(e, partial) - playerX;
        double offz = playerZ - minimap.getEntityRadar().getEntityZ(e, partial);
        double offh = p.field_70163_u - e.field_70163_u;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(offx * this.zoom), (double)(offz * this.zoom), (double)0.0);
        if (!this.modMain.getSettings().getLockNorth()) {
            GL11.glRotatef((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
        int color = minimap.getEntityRadar().getEntityColour(p, e, offh);
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)f, (float)f1, (float)f2, (float)1.0f);
        GL11.glScalef((float)this.modMain.getSettings().dotsScale, (float)this.modMain.getSettings().dotsScale, (float)1.0f);
        this.helper.drawMyTexturedModalRect(-2.0f, -3.0f, this.modMain.getSettings().getSmoothDots() ? 2 : 10, this.modMain.getSettings().getSmoothDots() ? 89 : 78, 6.0f, 6.0f, 256.0f);
        GL11.glPopMatrix();
    }

    public void deleteFramebuffers() {
        this.scalingFramebuffer.func_147608_a();
        this.rotationFramebuffer.func_147608_a();
    }

    public boolean isLoadedFBO() {
        return this.loadedFBO;
    }

    public void setLoadedFBO(boolean loadedFBO) {
        this.loadedFBO = loadedFBO;
    }

    public boolean isTriedFBO() {
        return this.triedFBO;
    }
}

