/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.plugins.vanilla;

import java.text.DecimalFormat;
import java.util.List;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.TooltipPosition;
import net.darkhax.wawla.lib.Feature;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class FeatureHorse
extends Feature
implements IEntityComponentProvider {
    private static final ResourceLocation SHOW_JUMP = new ResourceLocation("wawla", "horse_jump");
    private static final ResourceLocation SHOW_SPEED = new ResourceLocation("wawla", "horse_speed");
    private static final DecimalFormat FORMAT = new DecimalFormat("#.####");

    @Override
    public void initialize(IRegistrar hwyla) {
        hwyla.addConfig(SHOW_JUMP, true);
        hwyla.addConfig(SHOW_SPEED, true);
        hwyla.registerComponentProvider((IEntityComponentProvider)this, TooltipPosition.BODY, AbstractHorseEntity.class);
    }

    public void appendBody(List<ITextComponent> info, IEntityAccessor accessor, IPluginConfig config) {
        Entity entity = accessor.getEntity();
        if (entity instanceof AbstractHorseEntity) {
            AbstractHorseEntity horse = (AbstractHorseEntity)entity;
            if (config.get(SHOW_JUMP)) {
                this.addInfo(info, "jump", FORMAT.format(horse.func_110215_cj()));
            }
            if (config.get(SHOW_SPEED)) {
                double horseSpeed = horse.func_110148_a(Attributes.field_233821_d_).func_111126_e();
                this.addInfo(info, "speed", FORMAT.format(horseSpeed));
            }
        }
    }
}

