/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.json.world;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.registry.implement.IPostInit;
import com.builtbroken.mc.debug.IJsonDebugDisplay;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import com.builtbroken.mc.framework.json.loading.JsonProcessorData;
import com.builtbroken.mc.framework.json.processors.JsonGenData;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.lib.world.generator.OreGenReplace;
import com.builtbroken.mc.lib.world.generator.OreGeneratorSettings;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class JsonWorldOreGenData
extends JsonGenData
implements IPostInit,
IJsonDebugDisplay {
    public Object block;
    public String key;
    @JsonProcessorData(value={"type"})
    public String type;
    public int min_y;
    public int max_y;
    public int branchSize;
    public int chunkLimit;

    public JsonWorldOreGenData(IJsonProcessor processor, Object block, String key, int min, int max, int branch, int chunk) {
        super(processor);
        this.block = block;
        this.key = key;
        this.min_y = min;
        this.max_y = max;
        this.branchSize = branch;
        this.chunkLimit = chunk;
    }

    @Override
    public void onPostInit() {
        ItemStack stack = this.toStack(this.block);
        if (stack != null && stack.func_77973_b() instanceof ItemBlock) {
            if (Engine.loaderInstance.getConfig().getBoolean((this.modID != null ? this.modID + ":" : "") + LanguageUtility.capitalizeFirst(this.key) + "_Ore", "WorldGen", true, "Enables generation of the ore in the world")) {
                GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenReplace(((ItemBlock)stack.func_77973_b()).field_150939_a, stack.func_77960_j(), new OreGeneratorSettings(this.min_y, this.max_y, this.chunkLimit, this.branchSize), "pickaxe", 1), (int)1);
            }
        } else {
            Engine.logger().error("JsonWorldOreGenData: stack '" + stack + "' can not be used for world generation for generator '" + this.key + "'.");
        }
    }

    @Override
    public String getContentID() {
        return this.key;
    }

    @Override
    public void addDebugLines(List<String> lines) {
        lines.add("Block: " + this.block);
        lines.add("Type: " + this.type);
        lines.add("Y level: " + this.min_y + " - " + this.max_y);
        lines.add("Branch Size: " + this.branchSize);
        lines.add("Chunk Limit: " + this.chunkLimit);
    }
}

