/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.json.recipe.crafting;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.seven.framework.block.IJsonBlockSubProcessor;
import com.builtbroken.mc.seven.framework.json.recipe.JsonRecipeProcessor;
import com.builtbroken.mc.seven.framework.json.recipe.crafting.JsonCraftingRecipeData;
import com.builtbroken.mc.seven.framework.json.recipe.crafting.shaped.JsonShapedRecipeData;
import com.builtbroken.mc.seven.framework.json.recipe.crafting.shaped.JsonSheetMetalRecipeData;
import com.builtbroken.mc.seven.framework.json.recipe.crafting.shaped.JsonToolRecipeData;
import com.builtbroken.mc.seven.framework.json.recipe.crafting.shapeless.JsonShapelessRecipeData;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;

public class JsonCraftingRecipeProcessor
extends JsonRecipeProcessor<JsonCraftingRecipeData>
implements IJsonBlockSubProcessor {
    @Override
    public String getMod() {
        return "voltzengine";
    }

    @Override
    public String getJsonKey() {
        return "craftingGridRecipe";
    }

    @Override
    public String getLoadOrder() {
        return "after:oreName";
    }

    @Override
    public JsonCraftingRecipeData process(Object out, JsonElement element) {
        String recipeType;
        Object output;
        JsonObject recipeData = element.getAsJsonObject();
        JsonCraftingRecipeProcessor.ensureValuesExist(recipeData, "type");
        String subType = null;
        if (recipeData.has("subType")) {
            subType = recipeData.getAsJsonPrimitive("subType").getAsString();
        }
        if ((output = out) == null) {
            JsonCraftingRecipeProcessor.ensureValuesExist(recipeData, "output");
            JsonElement outputElement = recipeData.get("output");
            output = JsonCraftingRecipeProcessor.getItemFromJson(outputElement);
        }
        if ((recipeType = recipeData.getAsJsonPrimitive("type").getAsString()).equalsIgnoreCase("shaped")) {
            String[] craftingGridRows;
            JsonCraftingRecipeProcessor.ensureValuesExist(recipeData, "grid", "items");
            JsonElement gridElement = recipeData.get("grid");
            if (gridElement.isJsonPrimitive()) {
                craftingGridRows = gridElement.getAsJsonPrimitive().getAsString().split(",");
            } else {
                JsonArray gridArray = gridElement.getAsJsonArray();
                craftingGridRows = new String[gridArray.size()];
                int i = 0;
                for (JsonElement e : gridArray) {
                    if (e.isJsonPrimitive()) {
                        craftingGridRows[i++] = e.getAsJsonPrimitive().getAsString();
                        continue;
                    }
                    throw new RuntimeException("Recipe array must contain only string values of characters representing items.");
                }
            }
            JsonObject itemObject = recipeData.getAsJsonObject("items");
            HashMap<Character, Object> items = new HashMap<Character, Object>();
            for (Map.Entry entry : itemObject.entrySet()) {
                if (((String)entry.getKey()).length() == 1) {
                    char c = ((String)entry.getKey()).charAt(0);
                    if (c == '.' || Character.isWhitespace(c)) {
                        throw new RuntimeException("File contains invalid recipe data for item entry in recipe [" + (String)entry.getKey() + " -> " + entry.getValue() + "]. Each entry must be a single character that is not a space or a '.' which is used in place of a space.");
                    }
                    items.put(Character.valueOf(c), JsonCraftingRecipeProcessor.getItemFromJson((JsonElement)entry.getValue()));
                    continue;
                }
                throw new RuntimeException("File contains invalid recipe data for item entry in recipe [" + (String)entry.getKey() + " -> " + entry.getValue() + "] each item must be represented by a single character.");
            }
            boolean largeGrid = craftingGridRows.length > 3;
            int size = 0;
            for (int i = 0; i < craftingGridRows.length; ++i) {
                String gridRow = craftingGridRows[i];
                if (gridRow.contains(".")) {
                    craftingGridRows[i] = gridRow = gridRow.replace('.', ' ');
                }
                int l = gridRow.length();
                if (size > 0 && l != size) {
                    throw new RuntimeException("Crafting grid row[" + i + "] is not the same size of " + size + " as previous grid rows. This will prevent the recipe from loading correctly and needs to be fixed.");
                }
                if (l > size) {
                    size = l;
                }
                if (l > 3) {
                    largeGrid = true;
                }
                char[] chars = gridRow.toCharArray();
                for (int charIndex = 0; charIndex < chars.length; ++charIndex) {
                    char c = chars[charIndex];
                    if (Character.isWhitespace(c) || items.containsKey(Character.valueOf(c))) continue;
                    throw new RuntimeException("File is missing an entry for item linked to '" + c + "' for crafting grid row[" + i + "] index[" + charIndex + "] in recipe data -> " + recipeData);
                }
            }
            Object[] data = new Object[craftingGridRows.length + items.size() * 2];
            for (int i = 0; i < craftingGridRows.length; ++i) {
                data[i] = craftingGridRows[i];
            }
            for (Map.Entry entry : items.entrySet()) {
                data[i++] = entry.getKey();
                data[i++] = entry.getValue();
            }
            if (subType != null) {
                if (subType.equalsIgnoreCase("tool")) {
                    return new JsonToolRecipeData(this, output, data, largeGrid);
                }
                if (subType.equalsIgnoreCase("sheetmetal")) {
                    return new JsonSheetMetalRecipeData(this, output, data, largeGrid);
                }
                Engine.logger().error("JsonCraftingRecipeProcessor: could not ID subtype '" + subType + "' for crafting grid recipe, will default to normal recipe");
            }
            return new JsonShapedRecipeData(this, output, data, largeGrid);
        }
        if (recipeType.equalsIgnoreCase("shapeless")) {
            JsonCraftingRecipeProcessor.ensureValuesExist(recipeData, "items");
            Object[] items = recipeData.getAsJsonPrimitive("items").getAsString().split(",");
            return new JsonShapelessRecipeData(this, output, items, items.length > 9);
        }
        throw new RuntimeException("File is contains an unknown grid recipe type of " + recipeType + " that is not supported.");
    }
}

