/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.json.item;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.item.ItemBase;
import com.builtbroken.mc.framework.item.ItemNode;
import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import com.builtbroken.mc.framework.json.loading.JsonProcessorInjectionMap;
import com.builtbroken.mc.framework.json.processors.JsonProcessor;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;

public class JsonItemProcessor
extends JsonProcessor<ItemBase> {
    protected final JsonProcessorInjectionMap itemPropDataHandler = new JsonProcessorInjectionMap(ItemNode.class);

    @Override
    public String getMod() {
        return "voltzengine";
    }

    @Override
    public String getJsonKey() {
        return "item";
    }

    @Override
    public String getLoadOrder() {
        return "after:block";
    }

    @Override
    public boolean process(JsonElement element, List<IJsonGenObject> objectList) {
        ItemBase item;
        Class<?> clazz;
        String className;
        this.debugPrinter.start("ItemProcessor", "Processing entry", Engine.runningAsDev);
        JsonObject itemData = element.getAsJsonObject();
        JsonItemProcessor.ensureValuesExist(itemData, "name");
        if (itemData.has("itemClass")) {
            className = itemData.get("itemClass").getAsString();
            this.debugPrinter.log("ItemClass: " + className);
            try {
                clazz = Class.forName(className);
                item = (ItemBase)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to find item class for '" + className + "'", e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Failed to create item for class '" + className + "'", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access item constructor for class '" + className + "'", e);
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error creating node from '" + className + "'", e);
            }
        } else if (itemData.has("nodeClass")) {
            className = itemData.get("nodeClass").getAsString();
            this.debugPrinter.log("NodeClass: " + className);
            try {
                clazz = Class.forName(className);
                ItemNode node = (ItemNode)clazz.newInstance();
                item = new ItemBase(node);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to find class for '" + className + "' in order to construct item node", e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Failed to create constructor for class '" + className + "'", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access node constructor for class '" + className + "'", e);
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error creating node from '" + className + "'", e);
            }
        } else {
            JsonItemProcessor.ensureValuesExist(itemData, "id", "mod");
            String id = itemData.getAsJsonPrimitive("id").getAsString();
            String mod = itemData.getAsJsonPrimitive("mod").getAsString();
            String name = itemData.getAsJsonPrimitive("name").getAsString();
            item = new ItemBase(id, mod, name);
            this.debugPrinter.log("Name: " + name);
            this.debugPrinter.log("Mod: " + mod);
            this.debugPrinter.log("ID: " + id);
        }
        for (Map.Entry entry : itemData.entrySet()) {
            if (!this.itemPropDataHandler.handle(item.node, ((String)entry.getKey()).toLowerCase(), entry.getValue()) || !Engine.runningAsDev) continue;
            this.debugPrinter.log("Injected Key: " + (String)entry.getKey());
        }
        objectList.add(item);
        this.debugPrinter.end("Done...");
        return true;
    }
}

