/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.json.extra;

import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import com.builtbroken.mc.framework.json.processors.JsonProcessor;
import com.builtbroken.mc.seven.framework.block.BlockBase;
import com.builtbroken.mc.seven.framework.block.IJsonBlockSubProcessor;
import com.builtbroken.mc.seven.framework.block.meta.MetaData;
import com.builtbroken.mc.seven.framework.json.extra.JsonOreNameData;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;

public class JsonOreNameProcessor
extends JsonProcessor<JsonOreNameData>
implements IJsonBlockSubProcessor {
    @Override
    public String getMod() {
        return "voltzengine";
    }

    @Override
    public String getJsonKey() {
        return "oreName";
    }

    @Override
    public String getLoadOrder() {
        return "after:item";
    }

    @Override
    public JsonOreNameData process(JsonElement element) {
        JsonObject data = element.getAsJsonObject();
        JsonOreNameProcessor.ensureValuesExist(data, "name", "item");
        String name = data.getAsJsonPrimitive("name").getAsString();
        String item = data.getAsJsonPrimitive("item").getAsString();
        return new JsonOreNameData(this, name, item);
    }

    @Override
    public void process(BlockBase block, JsonElement element, List<IJsonGenObject> objectList) {
        if (element instanceof JsonObject) {
            JsonObject data = element.getAsJsonObject();
            JsonOreNameProcessor.ensureValuesExist(data, "name");
            block.data.oreName = data.getAsJsonPrimitive("name").getAsString();
        } else if (element instanceof JsonPrimitive) {
            block.data.oreName = element.getAsJsonPrimitive().getAsString();
        }
    }

    @Override
    public void process(MetaData meta, BlockBase block, JsonElement element, List<IJsonGenObject> objectList) {
        if (element instanceof JsonObject) {
            JsonObject data = element.getAsJsonObject();
            JsonOreNameProcessor.ensureValuesExist(data, "name");
            meta.addOreName(data.getAsJsonPrimitive("name").getAsString());
        } else if (element instanceof JsonPrimitive) {
            meta.addOreName(element.getAsJsonPrimitive().getAsString());
        }
    }
}

