/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.block.listeners;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.abstraction.entity.IEntityData;
import com.builtbroken.mc.api.data.ActionResponse;
import com.builtbroken.mc.api.tile.access.IRotation;
import com.builtbroken.mc.api.tile.multiblock.IMultiTile;
import com.builtbroken.mc.api.tile.multiblock.IMultiTileHost;
import com.builtbroken.mc.api.tile.node.ITileNode;
import com.builtbroken.mc.api.tile.node.ITileNodeHost;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.block.imp.IActivationListener;
import com.builtbroken.mc.framework.block.imp.IBlockListener;
import com.builtbroken.mc.framework.block.imp.IDestroyedListener;
import com.builtbroken.mc.framework.block.imp.IPlacementListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListenerBuilder;
import com.builtbroken.mc.framework.block.imp.IUpdateListener;
import com.builtbroken.mc.framework.json.loading.JsonProcessorData;
import com.builtbroken.mc.framework.multiblock.MultiBlockHelper;
import com.builtbroken.mc.framework.multiblock.structure.MultiBlockLayout;
import com.builtbroken.mc.framework.multiblock.structure.MultiBlockLayoutHandler;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.BlockUtility;
import com.builtbroken.mc.seven.framework.block.listeners.TileListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MultiBlockListener
extends TileListener
implements IBlockListener,
IPlacementListener,
IDestroyedListener,
IUpdateListener,
IMultiTileHost {
    private boolean _destroyingStructure = false;
    @JsonProcessorData(value={"layoutKey"})
    protected String layoutKey;
    @JsonProcessorData(value={"doRotation"})
    protected boolean doRotation = false;
    @JsonProcessorData(value={"buildFirstTick"})
    protected boolean buildFirstTick = true;
    @JsonProcessorData(value={"directionOffset"})
    protected boolean directionOffset = false;
    @JsonProcessorData(value={"directionMultiplier"}, type="int")
    protected int directionMultiplier = 1;

    @Override
    public List<String> getListenerKeys() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("placement");
        list.add("break");
        list.add("break");
        list.add("update");
        list.add("multiblock");
        return list;
    }

    @Override
    public void update(long ticks) {
        if (this.world().isServer()) {
            long offsetTick = ticks + (long)Math.abs(this.xi() + this.yi() + this.zi());
            if (ticks == 0L && this.buildFirstTick) {
                String string = this.layoutKey = this.layoutKey != null ? this.layoutKey.toLowerCase() : "";
                if (MultiBlockHelper.canBuild((IBlockAccess)this.world().unwrap(), this.getMultiTileHost(), true)) {
                    MultiBlockHelper.buildMultiBlock((World)this.world().unwrap(), this.getMultiTileHost() != null ? this.getMultiTileHost() : this, true, true);
                } else {
                    Engine.logger().error("Can not build multiblock structure at location " + new Location((World)this.world().unwrap(), this.xi(), this.yi(), this.zi()) + " for " + this.getMultiTileHost());
                }
            } else if (offsetTick % 200L == 0L) {
                MultiBlockHelper.buildMultiBlock((World)this.world().unwrap(), this.getMultiTileHost() != null ? this.getMultiTileHost() : this, true, true);
            }
        }
    }

    protected IMultiTileHost getMultiTileHost() {
        ITileNode node;
        TileEntity tileEntity = this.getTileEntity();
        if (tileEntity instanceof IMultiTileHost) {
            return (IMultiTileHost)tileEntity;
        }
        if (tileEntity instanceof ITileNodeHost && (node = ((ITileNodeHost)tileEntity).getTileNode()) instanceof IMultiTileHost) {
            return (IMultiTileHost)((Object)node);
        }
        return null;
    }

    @Override
    public void onMultiTileAdded(IMultiTile tileMulti) {
        if (tileMulti instanceof TileEntity && this.getLayoutOfMultiBlock().containsKey(new Pos(this).sub(new Pos((TileEntity)tileMulti)))) {
            tileMulti.setHost(this.getMultiTileHost());
        }
    }

    @Override
    public boolean onMultiTileBroken(IMultiTile tileMulti, Object source, boolean harvest) {
        if (!this._destroyingStructure && tileMulti instanceof TileEntity) {
            Pos pos = (Pos)((Pos)new Pos((TileEntity)tileMulti).floor()).sub((IPos3D)new Pos(this).floor());
            HashMap<IPos3D, String> map = this.getLayoutOfMultiBlock();
            if (map != null && map.containsKey((Object)pos)) {
                this._destroyingStructure = true;
                MultiBlockHelper.destroyMultiBlockStructure(this.getMultiTileHost() != null ? this.getMultiTileHost() : this, harvest, true, true);
                this._destroyingStructure = false;
                return true;
            }
            if (Engine.runningAsDev) {
                System.out.println("Error map was null");
            }
        }
        return false;
    }

    @Override
    public void onTileInvalidate(IMultiTile tileMulti) {
    }

    @Override
    public boolean onMultiTileActivated(IMultiTile tile, EntityPlayer player, int side, float xHit, float yHit, float zHit) {
        IMultiTileHost tileEntity = this.getMultiTileHost();
        if (tileEntity instanceof IActivationListener) {
            return ((IActivationListener)((Object)tileEntity)).onPlayerActivated(player, side, xHit, yHit, zHit);
        }
        return this.getBlock().func_149727_a((World)this.world().unwrap(), this.xi(), this.yi(), this.zi(), player, side, xHit, yHit, zHit);
    }

    @Override
    public void onMultiTileClicked(IMultiTile tile, EntityPlayer player) {
        IMultiTileHost tileEntity = this.getMultiTileHost();
        if (tileEntity instanceof IActivationListener) {
            ((IActivationListener)((Object)tileEntity)).onPlayerClicked(player);
        }
    }

    @Override
    public HashMap<IPos3D, String> getLayoutOfMultiBlock() {
        if (this.doRotation) {
            TileEntity tileEntity = this.getTileEntity();
            ForgeDirection dir = null;
            if (tileEntity instanceof IRotation) {
                dir = ((IRotation)tileEntity).getDirection();
            } else if (tileEntity instanceof ITileNodeHost && ((ITileNodeHost)tileEntity).getTileNode() instanceof IRotation) {
                dir = ((IRotation)((Object)((ITileNodeHost)tileEntity).getTileNode())).getDirection();
            }
            return this.getLayoutOfMultiBlock(dir);
        }
        return MultiBlockLayoutHandler.get(this.layoutKey);
    }

    protected HashMap<IPos3D, String> getLayoutOfMultiBlock(ForgeDirection dir) {
        if (dir != null && dir != ForgeDirection.UNKNOWN) {
            HashMap<IPos3D, String> map;
            String key = this.layoutKey + "." + dir.name().toLowerCase();
            HashMap<Object, String> directionalMap = MultiBlockLayoutHandler.get(key);
            if (directionalMap == null && this.directionOffset && (map = MultiBlockLayoutHandler.get(this.layoutKey)) != null) {
                directionalMap = new HashMap();
                for (Map.Entry<IPos3D, String> entry : map.entrySet()) {
                    if (entry.getKey() == null) continue;
                    Pos pos = entry.getKey() instanceof Pos ? (Pos)entry.getKey() : new Pos(entry.getKey());
                    pos = (Pos)pos.add((IPos3D)new Pos(dir).multiply(this.directionMultiplier));
                    directionalMap.put((IPos3D)pos, entry.getValue());
                }
                MultiBlockLayout layout = new MultiBlockLayout(null, key);
                layout.tiles.putAll(directionalMap);
                MultiBlockLayoutHandler.register(layout);
            }
            return directionalMap;
        }
        return MultiBlockLayoutHandler.get(this.layoutKey);
    }

    @Override
    public void breakBlock(Block block, int meta) {
        MultiBlockHelper.destroyMultiBlockStructure(this.getMultiTileHost() != null ? this.getMultiTileHost() : this, true, true, false);
    }

    @Override
    public boolean removedByPlayer(EntityPlayer player, boolean willHarvest) {
        MultiBlockHelper.destroyMultiBlockStructure(this.getMultiTileHost() != null ? this.getMultiTileHost() : this, willHarvest, true, true);
        return true;
    }

    @Override
    public ActionResponse canPlaceAt() {
        return this.doRotation || MultiBlockHelper.canBuild((IBlockAccess)this.world().unwrap(), this.getMultiTileHost() != null ? this.getMultiTileHost() : this, true) ? ActionResponse.DO : ActionResponse.CANCEL;
    }

    @Override
    public ActionResponse canPlaceAt(IEntityData entity) {
        return !this.doRotation || MultiBlockHelper.canBuild((IBlockAccess)this.world().unwrap(), this.xi(), this.yi(), this.zi(), null, this.getLayoutOfMultiBlock(BlockUtility.determineForgeDirection(entity)), true) ? ActionResponse.DO : ActionResponse.CANCEL;
    }

    @Override
    protected boolean isValidForRuntime() {
        return true;
    }

    public static class Builder
    implements ITileEventListenerBuilder {
        @Override
        public ITileEventListener createListener(Block block) {
            return new MultiBlockListener();
        }

        @Override
        public String getListenerKey() {
            return "multiblock";
        }
    }
}

