/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.block.json;

import com.builtbroken.mc.abstraction.EngineLoader;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.json.event.JsonProcessorRegistryEvent;
import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import com.builtbroken.mc.framework.json.loading.JsonProcessorInjectionMap;
import com.builtbroken.mc.framework.json.processors.JsonProcessor;
import com.builtbroken.mc.framework.mod.loadable.ILoadable;
import com.builtbroken.mc.seven.framework.block.BlockBase;
import com.builtbroken.mc.seven.framework.block.BlockPropertyData;
import com.builtbroken.mc.seven.framework.block.IJsonBlockSubProcessor;
import com.builtbroken.mc.seven.framework.block.json.JsonBlockListenerProcessor;
import com.builtbroken.mc.seven.framework.block.json.JsonBlockSubProcessorSettings;
import com.builtbroken.mc.seven.framework.block.meta.BlockMeta;
import com.builtbroken.mc.seven.framework.block.meta.MetaData;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;

public class JsonBlockProcessor
extends JsonProcessor<BlockBase> {
    public final HashMap<String, IJsonBlockSubProcessor> subProcessors = new HashMap();
    public final List<String> blockFields = new ArrayList<String>();
    protected final JsonProcessorInjectionMap blockPropDataHandler = new JsonProcessorInjectionMap(BlockPropertyData.class);
    protected final JsonProcessorInjectionMap blockMetaDataHandler = new JsonProcessorInjectionMap(MetaData.class);

    public JsonBlockProcessor() {
        this.blockFields.add("id");
        this.blockFields.add("name");
        this.blockFields.add("mod");
        this.blockFields.add("subtypes");
        this.blockFields.add("material");
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.addSubProcessor("listeners", new JsonBlockListenerProcessor());
        this.addSubProcessor("settings", new JsonBlockSubProcessorSettings());
    }

    @SubscribeEvent
    public void onJsonProcessorRegister(JsonProcessorRegistryEvent event) {
        if (event.processor instanceof IJsonBlockSubProcessor) {
            this.addSubProcessor(event.processor.getJsonKey(), (IJsonBlockSubProcessor)((Object)event.processor));
        }
    }

    @Override
    public String getMod() {
        return "voltzengine";
    }

    @Override
    public String getJsonKey() {
        return "block";
    }

    @Override
    public String getLoadOrder() {
        return null;
    }

    @Override
    public boolean process(JsonElement element, List<IJsonGenObject> objectList) {
        BlockBase block;
        this.debugPrinter.start("BlockProcessor", "Processing entry", Engine.runningAsDev);
        JsonObject blockData = element.getAsJsonObject();
        JsonBlockProcessor.ensureValuesExist(blockData, "name", "id", "mod");
        String mod = blockData.getAsJsonPrimitive("mod").getAsString();
        String id = blockData.getAsJsonPrimitive("id").getAsString();
        String name = blockData.get("name").getAsString();
        this.debugPrinter.log("Name: " + name);
        this.debugPrinter.log("Mod: " + mod);
        this.debugPrinter.log("ID: " + id);
        BlockPropertyData blockPropertyData = new BlockPropertyData(this, id, mod, name);
        Iterator it = blockData.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            if (!this.blockPropDataHandler.handle(blockPropertyData, ((String)entry.getKey()).toLowerCase(), entry.getValue())) continue;
            if (Engine.runningAsDev) {
                this.debugPrinter.log("Injected Key: " + (String)entry.getKey());
            }
            it.remove();
        }
        if (blockData.has("subtypes")) {
            if (blockPropertyData.equals("${mod}:${name}")) {
                blockPropertyData.localization = blockPropertyData.localization + ".${meta}";
            }
            block = new BlockMeta(blockPropertyData);
            this.readMeta((BlockMeta)block, blockData.get("subtypes").getAsJsonArray(), objectList);
        } else {
            block = new BlockBase(blockPropertyData);
        }
        for (Map.Entry entry : blockData.entrySet()) {
            if (this.blockFields.contains(((String)entry.getKey()).toLowerCase())) continue;
            this.processUnknownEntry((String)entry.getKey(), (JsonElement)entry.getValue(), block, null, objectList);
        }
        objectList.add(block);
        this.debugPrinter.end("Done...");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readMeta(BlockMeta block, JsonArray array, List<IJsonGenObject> objectList) {
        for (int i = 0; i < array.size() && i < 16; ++i) {
            JsonObject json = array.get(i).getAsJsonObject();
            JsonBlockProcessor.ensureValuesExist(json, "id");
            MetaData metadata = new MetaData(json.get("id").getAsString());
            ArrayList<String> keysUsed = new ArrayList<String>();
            keysUsed.add("id");
            for (Map.Entry entry : json.entrySet()) {
                if (!this.blockMetaDataHandler.handle(metadata, (String)entry.getKey(), entry.getValue()) && !keysUsed.contains(entry.getKey())) {
                    this.processUnknownEntry((String)entry.getKey(), (JsonElement)entry.getValue(), block, metadata, objectList);
                    continue;
                }
                keysUsed.add((String)entry.getKey());
            }
            int index = metadata.index;
            if (index == -1) throw new IllegalArgumentException("JsonBlockProcessor: Each meta entry requires the value 'meta' of type Integer");
            if (index < 0 || index >= 16) throw new IllegalArgumentException("JsonBlockProcessor: Meta values are restricted from 0 to 15");
            if (block.metaDataValues[index] != null) {
                throw new IllegalArgumentException("JsonBlockProcessor: Meta value[" + index + "] was overridden inside the same file for block " + block.getContentID());
            }
            metadata.index = index;
            block.metaDataValues[index] = metadata;
        }
    }

    public void processUnknownEntry(String name, JsonElement element, BlockBase block, MetaData data, List<IJsonGenObject> objectList) {
        if (this.subProcessors.containsKey(name)) {
            if (this.subProcessors.get(name).canProcess(name, element)) {
                if (data != null) {
                    this.subProcessors.get(name).process(data, block, element, objectList);
                } else {
                    this.subProcessors.get(name).process(block, element, objectList);
                }
            } else {
                Engine.logger().error("JsonBlockProcessor: Error processing extra data for block " + block.data.getContentID() + ", processor rejected entry[" + name + "]=" + element);
            }
        } else {
            Engine.logger().error("JsonBlockProcessor: Error processing extra data for block " + block.data.getContentID() + ", no processor found for entry[" + name + "=" + element + "]");
        }
    }

    public void addSubProcessor(String entryName, IJsonBlockSubProcessor processor) {
        if (this.subProcessors.containsKey(entryName) && this.subProcessors.get(entryName) != null) {
            Engine.logger().error("JsonBlockProcessor: Error sub process " + entryName + " is being overridden by " + processor);
        }
        this.subProcessors.put(entryName, processor);
        if (this.subProcessors instanceof ILoadable) {
            EngineLoader.loader.applyModule((ILoadable)((Object)this.subProcessors));
        }
    }
}

