/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.block.json;

import com.builtbroken.mc.framework.block.imp.ITileEventListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListenerBuilder;
import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import com.builtbroken.mc.framework.json.loading.JsonProcessorInjectionMap;
import com.builtbroken.mc.framework.json.processors.JsonProcessor;
import com.builtbroken.mc.seven.framework.block.BlockBase;
import com.builtbroken.mc.seven.framework.block.json.JsonBlockSubProcessor;
import com.builtbroken.mc.seven.framework.block.meta.MetaData;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;

public class JsonBlockListenerProcessor
extends JsonBlockSubProcessor {
    public static HashMap<String, ITileEventListenerBuilder> builders = new HashMap();
    private static HashMap<Class, JsonProcessorInjectionMap> injectionMaps = new HashMap();

    public static void addBuilder(ITileEventListenerBuilder builder) {
        builders.put(builder.getListenerKey().toLowerCase(), builder);
    }

    @Override
    public void process(BlockBase block, JsonElement arrayElement, List<IJsonGenObject> objectList) {
        JsonArray array = arrayElement.getAsJsonArray();
        for (JsonElement element : array) {
            ITileEventListener listener;
            String key = null;
            JsonObject data = null;
            if (element.isJsonPrimitive()) {
                key = element.getAsString().toLowerCase();
            } else if (element.isJsonObject()) {
                JsonObject object = element.getAsJsonObject();
                JsonProcessor.ensureValuesExist(object, "id");
                key = object.get("id").getAsString().toLowerCase();
                data = object;
            }
            if (!builders.containsKey(key) || (listener = builders.get(key).createListener((Block)block)) == null) continue;
            if (data != null) {
                if (!injectionMaps.containsKey(listener.getClass())) {
                    injectionMaps.put(listener.getClass(), new JsonProcessorInjectionMap(listener.getClass()));
                }
                JsonProcessorInjectionMap injectionMap = injectionMaps.get(listener.getClass());
                for (Map.Entry entry : data.entrySet()) {
                    injectionMap.handle(listener, (String)entry.getKey(), entry.getValue());
                }
            }
            block.addListener(listener);
        }
    }

    @Override
    public void process(MetaData meta, BlockBase block, JsonElement element, List<IJsonGenObject> objectList) {
        this.process(block, element, objectList);
    }
}

