/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.abstraction.tile;

import com.builtbroken.mc.api.abstraction.data.ITileData;
import com.builtbroken.mc.api.abstraction.tile.ITile;
import com.builtbroken.mc.api.abstraction.tile.ITileMaterial;
import com.builtbroken.mc.api.abstraction.world.IWorld;
import com.builtbroken.mc.seven.abstraction.MinecraftWrapper;
import com.builtbroken.mc.seven.abstraction.world.TilePosition;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class TileInstance
implements ITile {
    private final TilePosition position;

    public TileInstance(TilePosition position) {
        this.position = position;
    }

    @Override
    public IWorld getWorld() {
        return this.position.getWorld();
    }

    @Override
    public int xCoord() {
        return this.position.xCoord();
    }

    @Override
    public int yCoord() {
        return this.position.yCoord();
    }

    @Override
    public int zCoord() {
        return this.position.zCoord();
    }

    @Override
    public ITileMaterial getMaterial() {
        Block block = this.getBlock();
        if (block != null) {
            return MinecraftWrapper.INSTANCE.getTileMaterial(block.func_149688_o());
        }
        return null;
    }

    @Override
    public ITileData getData() {
        return MinecraftWrapper.INSTANCE.getTileData(this.getBlock());
    }

    public Block getBlock() {
        return this.world().func_147439_a(this.xCoord(), this.yCoord(), this.zCoord());
    }

    private World world() {
        return this.position.getWorld().getWorld();
    }
}

