/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.entity;

import com.builtbroken.mc.api.entity.IBullet;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.prefab.entity.EntityBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class EntityProjectile
extends EntityBase
implements IBullet {
    public Entity shootingEntity;
    public UUID shootingEntityUUID;
    public Pos sourceOfProjectile;
    protected int inGroundKillTime = 1200;
    protected int inAirKillTime = 1200;
    protected DamageSource impact_damageSource = DamageSource.field_82728_o;
    public int xTile = -1;
    public int yTile = -1;
    public int zTile = -1;
    public int sideTile = -1;
    protected Block inBlockID;
    protected int inData;
    protected boolean inGround;
    protected int ticksInGround;
    protected int ticksInAir;

    public EntityProjectile(World world) {
        super(world);
        this.field_70155_l = 10.0;
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityProjectile(World world, double x, double y, double z) {
        super(world);
        this.func_70107_b(x, y, z);
        this.sourceOfProjectile = new Pos(x, y, z);
        this.field_70129_M = 0.0f;
    }

    public EntityProjectile(World world, EntityLivingBase shooter, EntityLivingBase target, float p_i1755_4_, float p_i1755_5_) {
        this(world);
        this.shootingEntity = shooter;
        this.sourceOfProjectile = new Pos((Entity)shooter);
        this.field_70163_u = shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f;
        double d0 = target.field_70165_t - shooter.field_70165_t;
        double d1 = target.field_70121_D.field_72338_b + (double)(target.field_70131_O / 3.0f) - this.field_70163_u;
        double d2 = target.field_70161_v - shooter.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        if (d3 >= 1.0E-7) {
            float f2 = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
            float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
            double d4 = d0 / d3;
            double d5 = d2 / d3;
            this.func_70012_b(shooter.field_70165_t + d4, this.field_70163_u, shooter.field_70161_v + d5, f2, f3);
            this.field_70129_M = 0.0f;
            float f4 = (float)d3 * 0.2f;
            this.func_70186_c(d0, d1 + (double)f4, d2, p_i1755_4_, p_i1755_5_);
        }
    }

    public EntityProjectile(World world, EntityLivingBase shooter, float f) {
        this(world, shooter, f, 1.0f);
    }

    public EntityProjectile(World world, EntityLivingBase shooter, float f, float distanceScale) {
        this(world, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A, f, distanceScale);
    }

    public EntityProjectile(World world, double x, double y, double z, float yaw, float pitch, float f, float distanceScale) {
        super(world);
        this.field_70155_l = 10.0;
        this.sourceOfProjectile = new Pos(x, y, z);
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(x, y, z, yaw, pitch);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f * distanceScale);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f * distanceScale);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, f * 1.5f, 1.0f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70071_h_() {
        Block block;
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        }
        if ((block = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile)).func_149688_o() != Material.field_151579_a) {
            block.func_149719_a((IBlockAccess)this.field_70170_p, this.xTile, this.yTile, this.zTile);
            AxisAlignedBB axisalignedbb = block.func_149668_a(this.field_70170_p, this.xTile, this.yTile, this.zTile);
            if (axisalignedbb != null && axisalignedbb.func_72318_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v))) {
                this.inGround = true;
            }
        }
        if (this.inGround) {
            int j = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
            if (block == this.inBlockID && j == this.inData) {
                ++this.ticksInGround;
                if (this.ticksInGround == this.inGroundKillTime) {
                    this.func_70106_y();
                }
            } else {
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            }
        } else {
            ++this.ticksInAir;
            if (this.ticksInAir >= this.inAirKillTime) {
                this.func_70106_y();
                return;
            }
            Vec3 rayStart = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            Vec3 rayEnd = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            MovingObjectPosition rayHit = this.field_70170_p.func_147447_a(rayStart, rayEnd, false, true, false);
            rayStart = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            rayEnd = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            if (rayHit != null) {
                rayEnd = Vec3.func_72443_a((double)rayHit.field_72307_f.field_72450_a, (double)rayHit.field_72307_f.field_72448_b, (double)rayHit.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double distanceToHit = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double distance;
                float hitBoxSizeScale;
                AxisAlignedBB hitBox;
                MovingObjectPosition entityRayHit;
                Entity checkEntity = (Entity)list.get(i);
                if (!this.shouldCollideWith(checkEntity) || checkEntity == this.shootingEntity && this.ticksInAir < 5 || (entityRayHit = (hitBox = checkEntity.field_70121_D.func_72314_b((double)(hitBoxSizeScale = 0.3f), (double)hitBoxSizeScale, (double)hitBoxSizeScale)).func_72327_a(rayStart, rayEnd)) == null || !((distance = rayStart.func_72438_d(entityRayHit.field_72307_f)) < distanceToHit) && distanceToHit != 0.0) continue;
                entity = checkEntity;
                distanceToHit = distance;
            }
            if (entity != null) {
                rayHit = new MovingObjectPosition(entity);
            }
            if (rayHit != null && rayHit.field_72313_a != MovingObjectPosition.MovingObjectType.MISS) {
                if (rayHit.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                    this.handleEntityCollision(rayHit, rayHit.field_72308_g);
                } else {
                    this.handleBlockCollision(rayHit);
                }
            }
            this.updateMotion();
        }
    }

    protected boolean shouldCollideWith(Entity entity) {
        return entity.func_70067_L() && entity != this.field_70153_n;
    }

    protected void handleBlockCollision(MovingObjectPosition movingobjectposition) {
        this.xTile = movingobjectposition.field_72311_b;
        this.yTile = movingobjectposition.field_72312_c;
        this.zTile = movingobjectposition.field_72309_d;
        this.sideTile = movingobjectposition.field_72310_e;
        this.inBlockID = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
        this.inData = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
        this.field_70159_w = (float)(movingobjectposition.field_72307_f.field_72450_a - this.field_70165_t);
        this.field_70181_x = (float)(movingobjectposition.field_72307_f.field_72448_b - this.field_70163_u);
        this.field_70179_y = (float)(movingobjectposition.field_72307_f.field_72449_c - this.field_70161_v);
        float velocity = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70165_t -= this.field_70159_w / (double)velocity * (double)0.05f;
        this.field_70163_u -= this.field_70181_x / (double)velocity * (double)0.05f;
        this.field_70161_v -= this.field_70179_y / (double)velocity * (double)0.05f;
        this.inGround = true;
        if (this.inBlockID.func_149688_o() != Material.field_151579_a) {
            this.inBlockID.func_149670_a(this.field_70170_p, this.xTile, this.yTile, this.zTile, (Entity)this);
        }
        this.onImpactTile(movingobjectposition);
    }

    @Deprecated
    protected void onImpactTile() {
    }

    protected void onImpactTile(MovingObjectPosition hit) {
        this.onImpactTile();
    }

    protected void handleEntityCollision(MovingObjectPosition movingobjectposition, Entity entityHit) {
        this.onImpactEntity(entityHit, this.getSpeed(), movingobjectposition);
    }

    protected void onImpactEntity(Entity entityHit, float velocity, MovingObjectPosition hit) {
        this.onImpactEntity(entityHit, this.getSpeed());
    }

    protected void onImpactEntity(Entity entityHit, float velocity) {
        if (!this.field_70170_p.field_72995_K) {
            float vel_horizontal;
            int damage = MathHelper.func_76143_f((double)((double)velocity * 2.0));
            if (this.impact_damageSource != null && entityHit.func_70097_a(this.impact_damageSource, (float)damage) && entityHit instanceof EntityLivingBase && (vel_horizontal = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                entityHit.func_70024_g(this.field_70159_w * (double)0.6f / (double)vel_horizontal, 0.1, this.field_70179_y * (double)0.6f / (double)vel_horizontal);
            }
            this.func_70106_y();
        }
    }

    protected void updateMotion() {
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        this.decreaseMotion();
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    protected void decreaseMotion() {
        this.field_70159_w *= (double)0.99f;
        this.field_70181_x *= (double)0.99f;
        this.field_70179_y *= (double)0.99f;
        this.field_70181_x -= (double)0.05f;
    }

    public void func_70186_c(double xx, double yy, double zz, float multiplier, float random) {
        float velocity = MathHelper.func_76133_a((double)(xx * xx + yy * yy + zz * zz));
        xx /= (double)velocity;
        yy /= (double)velocity;
        zz /= (double)velocity;
        if (random > 0.0f) {
            xx += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)random;
            yy += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)random;
            zz += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)random;
        }
        this.field_70159_w = xx *= (double)multiplier;
        this.field_70181_x = yy *= (double)multiplier;
        this.field_70179_y = zz *= (double)multiplier;
        float f3 = MathHelper.func_76133_a((double)(xx * xx + zz * zz));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(xx, zz) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(yy, f3) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double p_70056_1_, double p_70056_3_, double p_70056_5_, float p_70056_7_, float p_70056_8_, int p_70056_9_) {
        this.func_70107_b(p_70056_1_, p_70056_3_, p_70056_5_);
        this.func_70101_b(p_70056_7_, p_70056_8_);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double xx, double yy, double zz) {
        this.field_70159_w = xx;
        this.field_70181_x = yy;
        this.field_70179_y = zz;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(xx * xx + zz * zz));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(xx, zz) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(yy, f) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74777_a("xTile", (short)this.xTile);
        nbt.func_74777_a("yTile", (short)this.yTile);
        nbt.func_74777_a("zTile", (short)this.zTile);
        nbt.func_74777_a("sideTile", (short)this.sideTile);
        nbt.func_74777_a("life", (short)this.ticksInGround);
        nbt.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.inBlockID));
        nbt.func_74774_a("inData", (byte)this.inData);
        nbt.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        if (this.sourceOfProjectile != null) {
            nbt.func_74782_a("sourcePos", (NBTBase)this.sourceOfProjectile.toNBT());
        }
        if (this.shootingEntity != null) {
            nbt.func_74778_a("Shooter-UUID", this.shootingEntity.func_110124_au().toString());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        this.xTile = nbt.func_74765_d("xTile");
        this.yTile = nbt.func_74765_d("yTile");
        this.zTile = nbt.func_74765_d("zTile");
        this.sideTile = nbt.func_74765_d("sideTile");
        this.ticksInGround = nbt.func_74765_d("life");
        this.inBlockID = Block.func_149729_e((int)(nbt.func_74771_c("inTile") & 0xFF));
        this.inData = nbt.func_74771_c("inData") & 0xFF;
        boolean bl = this.inGround = nbt.func_74771_c("inGround") == 1;
        if (nbt.func_74764_b("sourcePos")) {
            this.sourceOfProjectile = new Pos(nbt.func_74775_l("sourcePos"));
        }
        if (nbt.func_74764_b("Shooter-UUID")) {
            this.shootingEntityUUID = UUID.fromString(nbt.func_74779_i("Shooter-UUID"));
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public boolean func_70075_an() {
        return false;
    }

    @Override
    public boolean canBeDestroyed(Object attacker, DamageSource damageSource) {
        return this.hasHealth;
    }
}

