/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.energy;

import com.builtbroken.mc.api.energy.IEnergyBuffer;
import java.lang.ref.WeakReference;
import net.minecraft.tileentity.TileEntity;

public class EnergyBufferWrapper
implements IEnergyBuffer {
    public final IEnergyBuffer internalBuffer;
    public boolean acceptPower = true;
    public boolean releasePower = true;
    public WeakReference<TileEntity> connection;

    public EnergyBufferWrapper(IEnergyBuffer internalBuffer) {
        this.internalBuffer = internalBuffer;
    }

    @Override
    public int addEnergyToStorage(int energy, boolean doAction) {
        if (this.canAcceptPower()) {
            return this.internalBuffer.addEnergyToStorage(energy, doAction);
        }
        return 0;
    }

    @Override
    public int removeEnergyFromStorage(int energy, boolean doAction) {
        if (this.canReleasePower()) {
            return this.internalBuffer.removeEnergyFromStorage(energy, doAction);
        }
        return 0;
    }

    @Override
    public int getMaxBufferSize() {
        return this.internalBuffer.getMaxBufferSize();
    }

    @Override
    public int getEnergyStored() {
        return this.internalBuffer.getEnergyStored();
    }

    @Override
    public void setEnergyStored(int energy) {
        this.internalBuffer.setEnergyStored(energy);
    }

    public boolean hasConnection() {
        return this.connection != null && this.connection.get() != null && !((TileEntity)this.connection.get()).func_145837_r();
    }

    public TileEntity getConnection() {
        if (this.hasConnection()) {
            return (TileEntity)this.connection.get();
        }
        return null;
    }

    public void setConnection(TileEntity connection) {
        this.connection = new WeakReference<TileEntity>(connection);
    }

    public EnergyBufferWrapper disableInput() {
        this.acceptPower = false;
        return this;
    }

    public EnergyBufferWrapper enableInput() {
        this.acceptPower = true;
        return this;
    }

    public EnergyBufferWrapper disableOutput() {
        this.releasePower = false;
        return this;
    }

    public EnergyBufferWrapper enableOutput() {
        this.releasePower = true;
        return this;
    }

    public EnergyBufferWrapper toggleInput() {
        this.acceptPower = !this.acceptPower;
        return this;
    }

    public EnergyBufferWrapper toggleOutput() {
        this.releasePower = !this.releasePower;
        return this;
    }

    public boolean canAcceptPower() {
        return this.acceptPower;
    }

    public boolean canReleasePower() {
        return this.releasePower;
    }
}

