/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.mods.rf;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cofh.api.energy.IEnergyStorage;
import com.builtbroken.jlib.lang.StringHelpers;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.energy.EnergyHandler;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.ReflectionUtility;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RFEnergyHandler
extends EnergyHandler {
    public static RFEnergyHandler thermalExpansionHandler;
    public static double TO_RF_FROM_UE;
    public static double TO_UE_FROM_RF;
    private Map<Class, Field> classToEnergyFieldMap = new HashMap<Class, Field>();

    public RFEnergyHandler(double ratio) {
        super("rf", "flux", "rf", ratio);
        TO_RF_FROM_UE = this.toForeignEnergy;
        TO_UE_FROM_RF = this.toUEEnergy;
    }

    @Override
    public double receiveEnergy(Object handler, ForgeDirection direction, double energy, boolean doReceive) {
        if ((!(handler instanceof IEnergyConnection) || ((IEnergyConnection)handler).canConnectEnergy(direction)) && handler instanceof IEnergyReceiver) {
            return (double)((IEnergyReceiver)handler).receiveEnergy(direction, (int)(energy * this.toForeignEnergy), !doReceive) * this.toUEEnergy;
        }
        return 0.0;
    }

    @Override
    public double extractEnergy(Object handler, ForgeDirection direction, double energy, boolean doExtract) {
        if ((!(handler instanceof IEnergyConnection) || ((IEnergyConnection)handler).canConnectEnergy(direction)) && handler instanceof IEnergyProvider) {
            return (double)((IEnergyProvider)handler).extractEnergy(direction, (int)(energy * this.toForeignEnergy), !doExtract) * this.toUEEnergy;
        }
        return 0.0;
    }

    @Override
    public double clearEnergy(Object handler, boolean doAction) {
        if (thermalExpansionHandler != null && thermalExpansionHandler.handle(handler)) {
            return thermalExpansionHandler.clearEnergy(handler, doAction);
        }
        Class<?> handlerClass = handler.getClass();
        if (this.classToEnergyFieldMap.containsKey(handlerClass) && this.classToEnergyFieldMap.get(handlerClass) != null) {
            long start = System.nanoTime();
            try {
                Field field = this.classToEnergyFieldMap.get(handlerClass);
                IEnergyStorage storage = (IEnergyStorage)field.get(handler);
                if (storage instanceof EnergyStorage) {
                    int energy = storage.getEnergyStored();
                    if (doAction) {
                        ((EnergyStorage)storage).setEnergyStored(0);
                    }
                    return energy;
                }
                return (double)storage.extractEnergy(Integer.MAX_VALUE, !doAction) * this.toUEEnergy;
            }
            catch (Exception e) {
                Engine.logger().error("Failed to directly set energy value for " + handler, (Throwable)e);
                this.classToEnergyFieldMap.put(handlerClass, null);
                Engine.logger().info("Took " + StringHelpers.formatTimeDifference((long)start, (long)System.nanoTime()) + " to process reflection set for " + handler);
            }
        } else if (handler instanceof IEnergyProvider) {
            int drained = 0;
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                int energyStored = ((IEnergyProvider)handler).getEnergyStored(direction);
                int drain = ((IEnergyProvider)handler).extractEnergy(direction, Integer.MAX_VALUE, true);
                if (!doAction) {
                    drained += energyStored;
                    continue;
                }
                if (drain < energyStored) {
                    if (!this.classToEnergyFieldMap.containsKey(handlerClass)) {
                        long start = System.nanoTime();
                        try {
                            List<Field> fields = ReflectionUtility.getAllFields(handlerClass);
                            for (Field field : fields) {
                                if (!IEnergyStorage.class.isAssignableFrom(field.getType())) continue;
                                field.setAccessible(true);
                                this.classToEnergyFieldMap.put(handlerClass, field);
                                Engine.logger().info("Took " + StringHelpers.formatTimeDifference((long)start, (long)System.nanoTime()) + " to find energy field class for " + handlerClass);
                                return this.clearEnergy(handler, doAction);
                            }
                        }
                        catch (Exception e) {
                            Engine.logger().error("Unexpected error while finding energy storage field for " + handler, (Throwable)e);
                        }
                        Engine.logger().info("Took " + StringHelpers.formatTimeDifference((long)start, (long)System.nanoTime()) + " to fail find energy field class for " + handlerClass);
                        this.classToEnergyFieldMap.put(handlerClass, null);
                    }
                    drain = 0;
                    long startTime = System.currentTimeMillis();
                    while (energyStored > 0 && System.currentTimeMillis() - startTime > 100L) {
                        int d = ((IEnergyProvider)handler).extractEnergy(direction, Integer.MAX_VALUE, false);
                        energyStored -= d;
                        drain += d;
                    }
                    drained += drain;
                    continue;
                }
                drained += ((IEnergyProvider)handler).extractEnergy(direction, Integer.MAX_VALUE, false);
            }
            return (double)drained * this.toUEEnergy;
        }
        return 0.0;
    }

    @Override
    public double setFullCharge(Object handler) {
        if (thermalExpansionHandler != null && thermalExpansionHandler.handle(handler)) {
            return thermalExpansionHandler.setFullCharge(handler);
        }
        return this.receiveEnergy(handler, ForgeDirection.UNKNOWN, 2.147483647E9, true);
    }

    @Override
    public boolean doIsHandler(Object obj, ForgeDirection dir) {
        return obj instanceof IEnergyHandler || obj instanceof IEnergyProvider || obj instanceof IEnergyReceiver;
    }

    @Override
    public boolean doIsHandler(Object obj) {
        return obj instanceof IEnergyHandler || obj instanceof IEnergyProvider || obj instanceof IEnergyReceiver;
    }

    @Override
    public boolean doIsEnergyContainer(Object obj) {
        return obj instanceof IEnergyHandler || obj instanceof IEnergyProvider || obj instanceof IEnergyReceiver;
    }

    @Override
    public boolean canConnect(Object obj, ForgeDirection direction, Object source) {
        return obj instanceof IEnergyConnection ? ((IEnergyConnection)obj).canConnectEnergy(direction) : this.doIsEnergyContainer(obj);
    }

    @Override
    public double getEnergy(Object obj, ForgeDirection direction) {
        if (thermalExpansionHandler != null && thermalExpansionHandler.handle(obj)) {
            return thermalExpansionHandler.getEnergy(obj, direction);
        }
        return obj instanceof IEnergyReceiver ? (double)((IEnergyReceiver)obj).getEnergyStored(direction) * this.toUEEnergy : (obj instanceof IEnergyProvider ? (double)((IEnergyProvider)obj).getEnergyStored(direction) * this.toUEEnergy : 0.0);
    }

    @Override
    public double getMaxEnergy(Object obj, ForgeDirection direction) {
        if (thermalExpansionHandler != null && thermalExpansionHandler.handle(obj)) {
            return thermalExpansionHandler.getMaxEnergy(obj, direction);
        }
        return obj instanceof IEnergyReceiver ? (double)((IEnergyReceiver)obj).getMaxEnergyStored(direction) * this.toUEEnergy : (obj instanceof IEnergyProvider ? (double)((IEnergyProvider)obj).getMaxEnergyStored(direction) * this.toUEEnergy : 0.0);
    }

    @Override
    public double chargeItem(ItemStack is, double joules, boolean docharge) {
        if (is != null && is.func_77973_b() instanceof IEnergyContainerItem) {
            return (double)((IEnergyContainerItem)is.func_77973_b()).receiveEnergy(is, (int)(joules * this.toForeignEnergy), !docharge) * this.toUEEnergy;
        }
        return 0.0;
    }

    @Override
    public double dischargeItem(ItemStack is, double joules, boolean doDischarge) {
        if (is != null && is.func_77973_b() instanceof IEnergyContainerItem) {
            return (double)((IEnergyContainerItem)is.func_77973_b()).extractEnergy(is, (int)(joules * this.toForeignEnergy), !doDischarge) * this.toUEEnergy;
        }
        return 0.0;
    }

    @Override
    public ItemStack getItemWithCharge(ItemStack itemStack, double energy) {
        this.chargeItem(itemStack, energy * this.toForeignEnergy, true);
        return itemStack;
    }

    @Override
    public double getEnergyItem(ItemStack is) {
        return is != null && is.func_77973_b() instanceof IEnergyContainerItem ? (double)((IEnergyContainerItem)is.func_77973_b()).getEnergyStored(is) * this.toUEEnergy : 0.0;
    }

    @Override
    public double getMaxEnergyItem(ItemStack is) {
        return is != null && is.func_77973_b() instanceof IEnergyContainerItem ? (double)((IEnergyContainerItem)is.func_77973_b()).getMaxEnergyStored(is) * this.toUEEnergy : 0.0;
    }

    protected boolean handle(Object handler) {
        return false;
    }

    protected static int exportEnergyAllSides(World world, int x, int y, int z, IEnergyHandler exporter, int energy) {
        if (energy > 0) {
            HashMap<ForgeDirection, IEnergyHandler> connections = new HashMap<ForgeDirection, IEnergyHandler>();
            Pos center = new Pos(x, y, z);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                Pos pos;
                TileEntity tile;
                if (!exporter.canConnectEnergy(dir) || !((tile = (pos = (Pos)((Object)center.add(dir))).getTileEntity((IBlockAccess)world)) instanceof IEnergyHandler) || !((IEnergyHandler)tile).canConnectEnergy(dir.getOpposite())) continue;
                connections.put(dir, (IEnergyHandler)tile);
            }
            if (connections.size() > 0) {
                int totalEnergy = energy;
                for (Map.Entry entry : connections.entrySet()) {
                    int energySplit = totalEnergy / connections.size();
                    totalEnergy -= ((IEnergyHandler)entry.getValue()).receiveEnergy(((ForgeDirection)entry.getKey()).getOpposite(), energySplit, false);
                }
                return totalEnergy;
            }
        }
        return energy;
    }
}

