/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.map.data.s;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.ISave;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import net.minecraft.nbt.NBTTagCompound;

public class ChunkSectionShort
implements ISave {
    public final short[] data = new short[4096];

    public short getValue(int x, int y, int z) {
        int p = this.p(x, y, z);
        if (p >= 0 && p < this.data.length) {
            return this.data[p];
        }
        return 0;
    }

    public short getValue(IPos3D pos) {
        return this.getValue(pos.xi(), pos.yi(), pos.zi());
    }

    public void setValue(int x, int y, int z, short value) {
        this.data[this.p((int)x, (int)y, (int)z)] = value;
    }

    public void setValue(int x, int y, int z, int value) {
        this.data[this.p((int)x, (int)y, (int)z)] = (short)value;
    }

    public void setValue(IPos3D pos, short value) {
        this.setValue(pos.xi(), pos.yi(), pos.zi(), value);
    }

    public void setValue(IPos3D pos, int value) {
        this.setValue(pos.xi(), pos.yi(), pos.zi(), value);
    }

    public int p(int x, int y, int z) {
        return x << 8 | y << 4 | z;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        if (nbt.func_74764_b("data")) {
            byte[] payload = nbt.func_74770_j("data");
            ByteBuffer bb = ByteBuffer.wrap(payload).order(ByteOrder.BIG_ENDIAN);
            ShortBuffer sb = bb.asShortBuffer();
            int i = 0;
            while (sb.hasRemaining()) {
                this.data[i++] = sb.get();
            }
        }
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        ByteBuffer byteBuf = ByteBuffer.allocate(2 * this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            byteBuf.putShort(this.data[i]);
        }
        nbt.func_74773_a("data", byteBuf.array());
        return nbt;
    }
}

