/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.map.block;

import com.builtbroken.mc.lib.world.map.block.ExtendedBlockDataManager;
import com.builtbroken.mc.lib.world.map.data.ChunkMap;
import com.builtbroken.mc.lib.world.map.data.s.ChunkDataShort;

public class ExtendedBlockDataMap
extends ChunkMap<ChunkDataShort> {
    public ExtendedBlockDataMap(ExtendedBlockDataManager manager, int dimID) {
        super(manager, dimID);
    }

    public short getValue(int x, int y, int z) {
        ChunkDataShort chunk = (ChunkDataShort)this.getChunkFromBlockCoords(x, z);
        if (chunk != null) {
            return chunk.getValue(x & 0xF, y, z & 0xF);
        }
        return 0;
    }

    public short setValue(int x, int y, int z, int value) {
        return this.setValue(x, y, z, (short)value);
    }

    public short setValue(int x, int y, int z, short value) {
        ChunkDataShort chunk = (ChunkDataShort)this.getChunkFromBlockCoords(x, z);
        if (chunk != null) {
            short prev = chunk.getValue(x & 0xF, y, z & 0xF);
            chunk.setValue(x & 0xF, y, z & 0xF, value);
            return prev;
        }
        chunk = this.add(new ChunkDataShort(x >> 4, z >> 4));
        chunk.setValue(x & 0xF, y, z & 0xF, value);
        return 0;
    }

    public String toString() {
        return "ExtendedBlockDataMap[" + this.dimID + "]";
    }
}

