/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.edit;

import com.builtbroken.mc.api.edit.IWorldChangeAction;
import com.builtbroken.mc.api.edit.IWorldChangeAudio;
import com.builtbroken.mc.api.edit.IWorldChangeGraphics;
import com.builtbroken.mc.api.edit.IWorldEdit;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.event.WorldChangeActionEvent;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.explosive.blast.Blast;
import com.builtbroken.mc.framework.thread.action.WCAThreadProcess;
import com.builtbroken.mc.imp.transform.vector.Location;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public final class WorldChangeHelper {
    public static ChangeResult doAction(World world, double x, double y, double z, IWorldChangeAction action, TriggerCause triggerCause) {
        return WorldChangeHelper.doAction(new Location(world, x, y, z), action, triggerCause);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChangeResult doAction(Location loc, IWorldChangeAction action, TriggerCause triggerCause) {
        if (action == null) return ChangeResult.FAILED;
        if (action instanceof Blast && ((Blast)action).oldWorld() == null) {
            Engine.error("Error world is null in action object when attempting to trigger " + action);
            return ChangeResult.FAILED;
        }
        WorldChangeActionEvent.ActionCreated event = new WorldChangeActionEvent.ActionCreated(loc, action, triggerCause);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) return ChangeResult.BLOCKED;
        WorldChangeHelper.triggerStartAudio(action);
        WorldChangeHelper.triggerStartGraphics(action);
        action.doEffectOther(true);
        if (!loc.world.field_72995_K) {
            if (action.shouldThreadAction() > 0 || action.shouldThreadAction() == -2) {
                WCAThreadProcess thread = new WCAThreadProcess((Location)loc.clone(), action, triggerCause);
                thread.queProcess();
                return ChangeResult.COMPLETED;
            }
            ChangeResult returnValue = ChangeResult.COMPLETED;
            Collection<IWorldEdit> effectedBlocks = WorldChangeHelper.getEffectedBlocks(loc, triggerCause, action);
            if (effectedBlocks != null && !effectedBlocks.isEmpty()) {
                for (IWorldEdit v : effectedBlocks) {
                    if (v == null) continue;
                    try {
                        action.handleBlockPlacement(v);
                    }
                    catch (Exception e) {
                        Engine.error("Failed to apply edit " + v + " for " + action);
                        returnValue = ChangeResult.PARTIAL_COMPLETE_WITH_FAILURE;
                    }
                    try {
                        if (action instanceof IWorldChangeAudio) {
                            ((IWorldChangeAudio)((Object)action)).playAudioForEdit(v);
                        }
                        if (!(action instanceof IWorldChangeGraphics)) continue;
                        ((IWorldChangeGraphics)((Object)action)).displayEffectForEdit(v);
                    }
                    catch (Exception e) {
                        Engine.error("Failed to do graphics/audio for " + v + " for " + action);
                    }
                }
            }
            WorldChangeHelper.triggerEndAudio(action);
            WorldChangeHelper.triggerEndGraphics(action);
            action.doEffectOther(false);
            return returnValue;
        }
        WorldChangeHelper.triggerEndAudio(action);
        WorldChangeHelper.triggerEndGraphics(action);
        action.doEffectOther(false);
        return ChangeResult.COMPLETED;
    }

    private static void triggerStartAudio(IWorldChangeAction action) {
        try {
            if (action instanceof IWorldChangeAudio) {
                ((IWorldChangeAudio)((Object)action)).doStartAudio();
            }
        }
        catch (Exception e) {
            Engine.logger().error("Failed to trigger starting audio for " + action, (Throwable)e);
        }
    }

    private static void triggerStartGraphics(IWorldChangeAction action) {
        try {
            if (action instanceof IWorldChangeGraphics) {
                ((IWorldChangeGraphics)((Object)action)).doStartDisplay();
            }
        }
        catch (Exception e) {
            Engine.logger().error("Failed to trigger starting graphics for " + action, (Throwable)e);
        }
    }

    private static void triggerEndAudio(IWorldChangeAction action) {
        try {
            if (action instanceof IWorldChangeAudio) {
                ((IWorldChangeAudio)((Object)action)).doEndAudio();
            }
        }
        catch (Exception e) {
            Engine.logger().error("Failed to trigger ending audio for " + action, (Throwable)e);
        }
    }

    private static void triggerEndGraphics(IWorldChangeAction action) {
        try {
            if (action instanceof IWorldChangeGraphics) {
                ((IWorldChangeGraphics)((Object)action)).doEndDisplay();
            }
        }
        catch (Exception e) {
            Engine.logger().error("Failed to trigger ending graphics for " + action, (Throwable)e);
        }
    }

    public static Collection<IWorldEdit> getEffectedBlocks(Location vec, TriggerCause triggerCause, IWorldChangeAction blast) {
        Collection<IWorldEdit> effectedBlocks = blast.getEffectedBlocks();
        MinecraftForge.EVENT_BUS.post((Event)new WorldChangeActionEvent.FinishedCalculatingEffectEvent(vec, effectedBlocks, blast, triggerCause));
        if (effectedBlocks == null) {
            return new ArrayList<IWorldEdit>();
        }
        return effectedBlocks;
    }

    public static enum ChangeResult {
        COMPLETED,
        FAILED,
        BLOCKED,
        PARTIAL_COMPLETE_WITH_FAILURE;

    }
}

