/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.helper;

import com.builtbroken.mc.core.content.tool.ItemScrewdriver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class WrenchUtility {
    private static List<WrenchType> wrenchTypes = new ArrayList<WrenchType>();
    private static HashMap<Item, WrenchType> cache = new HashMap();

    public static boolean isHoldingWrench(EntityPlayer player) {
        return WrenchUtility.isWrench(player.func_70694_bm());
    }

    public static boolean isWrench(ItemStack itemStack) {
        if (itemStack != null) {
            if (itemStack.func_77973_b() instanceof ItemScrewdriver) {
                return true;
            }
            WrenchType type = WrenchUtility.getWrenchTypeFor(itemStack);
            if (type != null && type.isWrench(itemStack)) {
                return true;
            }
            for (WrenchType t : wrenchTypes) {
                if (!t.isWrench(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isUsableWrench(EntityPlayer player, int x, int y, int z) {
        return WrenchUtility.isUsableWrench(player, player.func_70694_bm(), x, y, z);
    }

    public static boolean isUsableWrench(EntityPlayer player, ItemStack itemStack, int x, int y, int z) {
        if (player != null && itemStack != null) {
            if (itemStack.func_77973_b() instanceof ItemScrewdriver) {
                return true;
            }
            WrenchType type = WrenchUtility.getWrenchTypeFor(itemStack);
            if (type != null && type.isUsableWrench(player, itemStack, x, y, z)) {
                return true;
            }
            for (WrenchType t : wrenchTypes) {
                if (!t.isUsableWrench(player, itemStack, x, y, z)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean damageWrench(EntityPlayer player, int x, int y, int z) {
        return WrenchUtility.damageWrench(player, player.func_70694_bm(), x, y, z);
    }

    public static boolean damageWrench(EntityPlayer player, ItemStack itemStack, int x, int y, int z) {
        if (WrenchUtility.isUsableWrench(player, itemStack, x, y, z)) {
            WrenchType type = WrenchUtility.getWrenchTypeFor(itemStack);
            if (type != null && type.damageWrench(player, itemStack, x, y, z)) {
                return true;
            }
            for (WrenchType t : wrenchTypes) {
                if (!t.damageWrench(player, itemStack, x, y, z)) continue;
                return true;
            }
        }
        return false;
    }

    public static WrenchType getWrenchTypeFor(ItemStack stack) {
        if (cache.containsKey(stack.func_77973_b())) {
            return cache.get(stack.func_77973_b());
        }
        return null;
    }

    public static void registerWrenchType(WrenchType type) {
        if (!wrenchTypes.contains(type)) {
            wrenchTypes.add(type);
        }
    }

    public static class WrenchType {
        public boolean isWrench(ItemStack itemStack) {
            return false;
        }

        public boolean damageWrench(EntityPlayer player, ItemStack itemStack, int x, int y, int z) {
            return false;
        }

        public boolean isUsableWrench(EntityPlayer player, ItemStack itemStack, int x, int y, int z) {
            return false;
        }
    }
}

