/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.imp.transform.vector;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.imp.transform.vector.AbstractPos;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class Pos
extends AbstractPos<Pos>
implements IPos3D {
    public static final Pos zero = new Pos();
    public static final Pos up = new Pos(ForgeDirection.UP);
    public static final Pos down = new Pos(ForgeDirection.DOWN);
    public static final Pos north = new Pos(ForgeDirection.NORTH);
    public static final Pos south = new Pos(ForgeDirection.SOUTH);
    public static final Pos east = new Pos(ForgeDirection.EAST);
    public static final Pos west = new Pos(ForgeDirection.WEST);

    public Pos() {
        this(0.0, 0.0, 0.0);
    }

    public Pos(double a) {
        this(a, a, a);
    }

    public Pos(double x, double y, double z) {
        super(x, y, z);
    }

    public Pos(double yaw, double pitch) {
        this(-Math.sin(Math.toRadians(yaw)), Math.sin(Math.toRadians(pitch)), -Math.cos(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch)));
    }

    public Pos(TileEntity tile) {
        this(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    public Pos(Entity entity) {
        this(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public Pos(IPos3D vec) {
        this(vec.x(), vec.y(), vec.z());
    }

    public Pos(IWorldPosition vec) {
        this(vec.x(), vec.y(), vec.z());
    }

    public Pos(NBTTagCompound nbt) {
        this(nbt.func_74769_h("x"), nbt.func_74769_h("y"), nbt.func_74769_h("z"));
    }

    public Pos(ByteBuf data) {
        this(data.readDouble(), data.readDouble(), data.readDouble());
    }

    public Pos(MovingObjectPosition par1) {
        this(par1.field_72311_b, par1.field_72312_c, par1.field_72309_d);
    }

    public Pos(ChunkCoordinates par1) {
        this(par1.field_71574_a, par1.field_71572_b, par1.field_71573_c);
    }

    public Pos(ForgeDirection dir) {
        this(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public Pos(EnumFacing dir) {
        this(dir.func_82601_c(), dir.func_96559_d(), dir.func_82599_e());
    }

    public Pos(Vec3 vec) {
        this(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Pos newPos(double x, double y, double z) {
        return new Pos(x, y, z);
    }

    public static Pos getLook(Entity entity, double distance) {
        double f1 = 0.0;
        double f2 = 0.0;
        double f3 = 0.0;
        double f4 = 0.0;
        if (distance == 1.0) {
            f1 = Math.cos((double)(-entity.field_70177_z * ((float)Math.PI / 180)) - Math.PI);
            f2 = Math.sin((double)(-entity.field_70177_z * ((float)Math.PI / 180)) - Math.PI);
            f3 = -Math.cos(-entity.field_70125_A * ((float)Math.PI / 180));
            f4 = Math.sin(-entity.field_70125_A * ((float)Math.PI / 180));
            return new Pos(f2 * f3, f4, f1 * f3);
        }
        f1 = (double)entity.field_70127_C + (double)(entity.field_70125_A - entity.field_70127_C) * distance;
        f2 = (double)entity.field_70126_B + (double)(entity.field_70177_z - entity.field_70126_B) * distance;
        f3 = Math.cos(-f2 * 0.01745329238474369 - Math.PI);
        f4 = Math.sin(-f2 * 0.01745329238474369 - Math.PI);
        double f5 = -Math.cos(-f1 * 0.01745329238474369);
        double f6 = Math.sin(-f1 * 0.01745329238474369);
        return new Pos(f4 * f5, f6, f3 * f5);
    }

    public static Pos getLook(double yaw, double pitch, double distance) {
        double f1 = 0.0;
        double f2 = 0.0;
        double f3 = 0.0;
        double f4 = 0.0;
        if (distance == 1.0) {
            f1 = Math.cos(-yaw * 0.01745329238474369 - Math.PI);
            f2 = Math.sin(-yaw * 0.01745329238474369 - Math.PI);
            f3 = -Math.cos(-pitch * 0.01745329238474369);
            f4 = Math.sin(-pitch * 0.01745329238474369);
            return new Pos(f2 * f3, f4, f1 * f3);
        }
        f1 = pitch * distance;
        f2 = yaw * distance;
        f3 = Math.cos(-f2 * 0.01745329238474369 - Math.PI);
        f4 = Math.sin(-f2 * 0.01745329238474369 - Math.PI);
        double f5 = -Math.cos(-f1 * 0.01745329238474369);
        double f6 = Math.sin(-f1 * 0.01745329238474369);
        return new Pos(f4 * f5, f6, f3 * f5);
    }

    public boolean equals(Object object) {
        return object instanceof IPos3D && Math.abs(((IPos3D)object).x() - this.x()) <= 0.001 && Math.abs(((IPos3D)object).y() - this.y()) <= 0.001 && Math.abs(((IPos3D)object).z() - this.z()) <= 0.001;
    }

    public int hashCode() {
        long x = Double.doubleToLongBits(this.x() * 100.0 / 100.0);
        long y = Double.doubleToLongBits(this.y() * 100.0 / 100.0);
        long z = Double.doubleToLongBits(this.z() * 100.0 / 100.0);
        long hash = x ^ x >>> 32;
        hash = 31L * hash + y ^ y >>> 32;
        hash = 31L * hash + z ^ z >>> 32;
        return (int)hash;
    }
}

