/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.imp.transform.region;

import com.builtbroken.jlib.data.vector.IPos2D;
import com.builtbroken.mc.imp.transform.region.Shape2D;
import com.builtbroken.mc.imp.transform.vector.Point;

public class Triangle
extends Shape2D {
    IPos2D a;
    IPos2D b;
    IPos2D c;

    public Triangle(IPos2D a, IPos2D b, IPos2D c) {
        super(null);
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public Triangle set(Triangle other) {
        this.a = other.a;
        this.b = other.b;
        this.c = other.c;
        return this;
    }

    @Override
    public boolean isWithin(double x, double y) {
        return this.isWithin(new Point(x, y));
    }

    @Override
    public boolean isWithin(IPos2D p) {
        double ca;
        double bc;
        double ab = new Triangle(this.a, this.b, p).getArea();
        return ab + (bc = new Triangle(this.b, this.c, p).getArea()) + (ca = new Triangle(this.c, this.a, p).getArea()) <= this.getArea();
    }

    @Override
    public double getArea() {
        return Math.abs(this.a.x() * (this.b.y() - this.c.y()) + this.b.x() * (this.c.y() - this.a.y()) + this.c.x() * (this.a.y() - this.b.y())) / 2.0;
    }

    @Override
    public double getSizeX() {
        double lower = this.a.x();
        double upper = this.a.x();
        if (this.b.x() < lower) {
            lower = this.b.x();
        }
        if (this.c.x() < lower) {
            lower = this.c.x();
        }
        if (this.b.x() > upper) {
            upper = this.b.x();
        }
        if (this.c.x() > upper) {
            upper = this.c.x();
        }
        return upper - lower;
    }

    @Override
    public double getSizeY() {
        double lower = this.a.y();
        double upper = this.a.y();
        if (this.b.y() < lower) {
            lower = this.b.y();
        }
        if (this.c.y() < lower) {
            lower = this.c.y();
        }
        if (this.b.y() > upper) {
            upper = this.b.y();
        }
        if (this.c.y() > upper) {
            upper = this.c.y();
        }
        return upper - lower;
    }
}

