/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.thread.delay;

import com.builtbroken.mc.framework.thread.delay.DelayedAction;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.world.World;

public class DelayedActionHandler {
    public static Map<Integer, List<DelayedAction>> worldToActions = new HashMap<Integer, List<DelayedAction>>();

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            List<DelayedAction> actions;
            World world = event.world;
            int dimID = world.field_73011_w.field_76574_g;
            if (worldToActions.containsKey(dimID) && (actions = worldToActions.get(dimID)) != null && actions.size() > 0) {
                Iterator<DelayedAction> it = actions.iterator();
                while (it.hasNext()) {
                    DelayedAction action = it.next();
                    if (action != null && action.isAlive) {
                        --action.ticksToWait;
                        if (action.ticksToWait > 0 || !action.trigger()) continue;
                        it.remove();
                        continue;
                    }
                    it.remove();
                }
            }
        }
    }

    public static <T extends DelayedAction> T add(T delayedAction) {
        if (delayedAction != null && delayedAction.world != null && delayedAction.world.field_73011_w != null) {
            List<Object> list = null;
            if (worldToActions.containsKey(delayedAction.world.field_73011_w.field_76574_g)) {
                list = worldToActions.get(delayedAction.world.field_73011_w.field_76574_g);
            }
            if (list == null) {
                list = new ArrayList<T>();
            }
            list.add(delayedAction);
            worldToActions.put(delayedAction.world.field_73011_w.field_76574_g, list);
        }
        return delayedAction;
    }
}

