/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.thread.action;

import com.builtbroken.mc.api.process.IWorldAction;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.LinkedList;
import java.util.Queue;

public final class WorldActionQue {
    private static final Queue<IWorldAction> editQues = new LinkedList<IWorldAction>();
    public static int MAX_EDITS_PER_TICK = 1000;
    private static IWorldAction currentQue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEditQue(IWorldAction queue) {
        Queue<IWorldAction> queue2 = editQues;
        synchronized (queue2) {
            if (!editQues.contains(queue)) {
                editQues.offer(queue);
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            long startTime = System.nanoTime();
            int edits = 0;
            while (System.nanoTime() - startTime < 10000L && edits < MAX_EDITS_PER_TICK) {
                int i;
                if (currentQue == null || currentQue.isQueDone()) {
                    currentQue = editQues.poll();
                }
                if (currentQue == null || (i = currentQue.runQue(event.world, event.side)) <= 0) continue;
                edits += i;
            }
        }
    }
}

