/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.recipe.extend;

import com.builtbroken.mc.api.recipe.IMachineRecipe;
import com.builtbroken.mc.api.recipe.MachineRecipeType;
import com.builtbroken.mc.api.recipe.RecipeRegisterResult;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.mod.loadable.AbstractLoadable;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import java.util.ArrayList;
import java.util.List;

public class MachineRecipeLoader<I extends IMachineRecipe>
extends AbstractLoadable {
    protected final String type;

    public MachineRecipeLoader(String type) {
        this.type = type;
    }

    @Override
    public void init() {
        ArrayList recipes = new ArrayList();
        this.generateRecipes(recipes);
        for (IMachineRecipe recipe : recipes) {
            RecipeRegisterResult result = MachineRecipeType.getHandler(this.type).registerRecipe(recipe);
            if (result == RecipeRegisterResult.REGISTERED) continue;
            Engine.logger().error("" + this.getClass().getSimpleName() + " failed to register recipe " + recipe + "  ErrorCode:" + (Object)((Object)result));
        }
    }

    protected void generateRecipes(List<I> recipes) {
    }

    @Override
    public boolean shouldLoad() {
        return Engine.loaderInstance.getConfig().getBoolean("Generator" + LanguageUtility.capitalizeFirst(this.type) + "Recipes", "AutoGenerator", true, "Disables the auto generator, which in turns prevents recipes from generating");
    }
}

