/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.recipe.cast;

import com.builtbroken.mc.api.items.crafting.ICastItem;
import com.builtbroken.mc.api.recipe.ICastingRecipe;
import com.builtbroken.mc.api.recipe.MachineRecipeType;
import com.builtbroken.mc.framework.recipe.cast.MRHandlerCast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class CastingRecipe
implements ICastingRecipe {
    protected final ItemStack output;
    protected final List<FluidStack> inputs;
    protected final String cast_type;

    public CastingRecipe(String cast_type, ItemStack output) {
        this.cast_type = cast_type;
        this.output = output;
        this.inputs = new ArrayList<FluidStack>();
    }

    @Override
    public String getType() {
        return MachineRecipeType.FLUID_CAST.name();
    }

    @Override
    public Collection<FluidStack> getValidInputs() {
        return this.inputs;
    }

    @Override
    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    @Override
    public boolean shouldHandleRecipe(Object[] inputs) {
        if (inputs != null && inputs.length == 2) {
            if (!(inputs[0] instanceof ItemStack) || !(((ItemStack)inputs[0]).func_77973_b() instanceof ICastItem)) {
                return false;
            }
            if (inputs[1] instanceof Fluid) {
                return this.getValidInputs().contains(new FluidStack((Fluid)inputs[0], MRHandlerCast.INSTANCE.getVolumeForCast(this.cast_type)));
            }
            if (inputs[1] instanceof FluidStack) {
                FluidStack stack = ((FluidStack)inputs[1]).copy();
                stack.amount = MRHandlerCast.INSTANCE.getVolumeForCast(this.cast_type);
                return this.getValidInputs().contains(stack);
            }
        }
        return false;
    }

    @Override
    public ItemStack handleRecipe(Object[] inputs, float extraChance, float failureChance) {
        return this.getOutput();
    }

    @Override
    public String getCastType() {
        return this.cast_type;
    }
}

