/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json.struct;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.json.imp.IJsonKeyDataProvider;
import com.builtbroken.mc.framework.json.processors.JsonProcessor;
import com.builtbroken.mc.framework.json.settings.JsonSettingData;
import com.builtbroken.mc.framework.json.settings.data.JsonSettingBoolean;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.common.Loader;
import java.util.Map;

public class JsonConditional {
    public static boolean isConditionalTrue(JsonElement element, Object dataProvider) {
        if (element.isJsonPrimitive()) {
            String value = element.getAsString();
            if (value.startsWith("setting@")) {
                String key = value.substring(8, value.length());
                JsonSettingData data = Engine.getSetting(key);
                if (data instanceof JsonSettingBoolean) {
                    return data.getBoolean();
                }
                return false;
            }
            if (value.startsWith("mod@")) {
                String modName = value.substring(4, value.length());
                if (!Loader.isModLoaded((String)modName)) {
                    return false;
                }
            } else if (!value.startsWith("if")) {
                if (value.equalsIgnoreCase("true")) {
                    return true;
                }
                if (value.equalsIgnoreCase("false")) {
                    return false;
                }
                if (value.equalsIgnoreCase("dev") || value.equalsIgnoreCase("devMode")) {
                    return Engine.runningAsDev;
                }
            }
        } else if (element.isJsonObject()) {
            JsonObject conditional = element.getAsJsonObject();
            if (conditional.has("IfAllTrue")) {
                JsonArray array = conditional.getAsJsonArray("IfAllTrue");
                for (JsonElement e : array) {
                    boolean result = JsonConditional.isConditionalTrue(e, dataProvider);
                    if (result) continue;
                    return false;
                }
            } else if (conditional.has("type")) {
                JsonProcessor.ensureValuesExist(conditional, "field", "check");
                boolean expectedResult = true;
                if (conditional.has("result")) {
                    expectedResult = conditional.get("result").getAsBoolean();
                }
                String type = conditional.getAsJsonPrimitive("type").getAsString();
                String field = conditional.getAsJsonPrimitive("field").getAsString();
                String check = conditional.getAsJsonPrimitive("check").getAsString();
                Object value = JsonConditional.get(field, dataProvider);
                if (type.equalsIgnoreCase("is")) {
                    return expectedResult == JsonConditional.is(check, value);
                }
                if (type.equalsIgnoreCase("isNot")) {
                    return expectedResult == JsonConditional.isNot(check, value);
                }
            }
        } else if (element.isJsonArray()) {
            // empty if block
        }
        return false;
    }

    protected static Object get(String field, Object dataProvider) {
        if (dataProvider instanceof IJsonKeyDataProvider) {
            return ((IJsonKeyDataProvider)dataProvider).getJsonKeyData(field);
        }
        if (dataProvider instanceof Map) {
            return ((Map)dataProvider).get(field);
        }
        return null;
    }

    protected static boolean is(String check, Object object) {
        if (object == null || check.isEmpty()) {
            return false;
        }
        if (object instanceof String) {
            return ((String)object).equalsIgnoreCase(check);
        }
        if (object instanceof Integer) {
            try {
                int i = Integer.parseInt(check);
                return i == (Integer)object;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (object instanceof Byte) {
            try {
                byte i = Byte.parseByte(check);
                return i == (Byte)object;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (object instanceof Double) {
            try {
                double i = Double.parseDouble(check);
                return i == (Double)object;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (object instanceof Float) {
            try {
                float i = Float.parseFloat(check);
                return i == ((Float)object).floatValue();
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (object instanceof Long) {
            try {
                long i = Long.parseLong(check);
                return i == (Long)object;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        String toString = object.toString();
        return toString.equalsIgnoreCase(check);
    }

    protected static boolean isNot(String check, Object object) {
        return !JsonConditional.is(check, object);
    }
}

