/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json.settings;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.json.loading.JsonProcessorInjectionMap;
import com.builtbroken.mc.framework.json.processors.JsonProcessor;
import com.builtbroken.mc.framework.json.settings.JsonSettingData;
import com.builtbroken.mc.framework.json.settings.data.JsonSettingBoolean;
import com.builtbroken.mc.framework.json.settings.data.JsonSettingInteger;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;

public class JsonSettingsProcessor
extends JsonProcessor<JsonSettingData> {
    public static final JsonSettingsProcessor INSTANCE = new JsonSettingsProcessor();
    HashMap<Class<? extends JsonSettingData>, JsonProcessorInjectionMap> injectionMaps = new HashMap();

    @Override
    public JsonSettingData process(JsonElement element) {
        JsonObject jsonData = element.getAsJsonObject();
        JsonSettingsProcessor.ensureValuesExist(jsonData, "key", "type", "value");
        this.debugPrinter.start("SettingProcessor", "Processing entry", Engine.runningAsDev);
        String key = jsonData.getAsJsonPrimitive("key").getAsString();
        String type = jsonData.getAsJsonPrimitive("type").getAsString();
        JsonPrimitive value = jsonData.getAsJsonPrimitive("value");
        this.debugPrinter.log("Key: " + key);
        this.debugPrinter.log("Type: " + type);
        this.debugPrinter.log("Value: " + value);
        Object settingData = null;
        if (!type.equalsIgnoreCase("byte") && !type.equalsIgnoreCase("short")) {
            if (type.equalsIgnoreCase("int") || type.equalsIgnoreCase("integer")) {
                settingData = new JsonSettingInteger(this, key, value.getAsInt());
            } else if (!type.equalsIgnoreCase("long") && !type.equalsIgnoreCase("float") && !type.equalsIgnoreCase("double") && type.equalsIgnoreCase("boolean")) {
                settingData = new JsonSettingBoolean(this, key, value.getAsBoolean());
            }
        }
        if (settingData != null) {
            if (!this.injectionMaps.containsKey(settingData.getClass())) {
                this.injectionMaps.put(settingData.getClass(), new JsonProcessorInjectionMap(settingData.getClass()));
            }
            JsonProcessorInjectionMap injectionMap = this.injectionMaps.get(settingData.getClass());
            try {
                for (Map.Entry entry : jsonData.entrySet()) {
                    if (!injectionMap.handle(settingData, ((String)entry.getKey()).toLowerCase(), entry.getValue()) || !Engine.runningAsDev) continue;
                    this.debugPrinter.log("Injected Key: " + (String)entry.getKey());
                }
                injectionMap.enforceRequired(settingData);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.debugPrinter.end();
        return settingData;
    }

    @Override
    public String getMod() {
        return "voltzengine";
    }

    @Override
    public String getJsonKey() {
        return "setting";
    }

    @Override
    public String getLoadOrder() {
        return null;
    }
}

