/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json.conversion.structures.arrays;

import com.builtbroken.mc.framework.json.conversion.JsonConverter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;

public class JsonConverterIntegerArray
extends JsonConverter<int[]> {
    public JsonConverterIntegerArray() {
        super("array.int", "array.integer");
    }

    @Override
    public int[] convert(JsonElement element, String ... args) {
        if (element instanceof JsonArray) {
            int[] array = new int[element.getAsJsonArray().size()];
            int index = 0;
            for (JsonElement e : element.getAsJsonArray()) {
                if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isNumber()) {
                    array[index++] = e.getAsInt();
                    continue;
                }
                throw new IllegalArgumentException("Can not convert object to int array, as '" + e + "' is not an integer");
            }
            return array;
        }
        return null;
    }
}

