/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json.conversion.data.transform;

import com.builtbroken.mc.framework.json.conversion.JsonConverter;
import com.builtbroken.mc.framework.json.conversion.data.transform.JsonConverterPos;
import com.builtbroken.mc.framework.json.processors.JsonProcessor;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class JsonConverterCube
extends JsonConverter<Cube> {
    public JsonConverterCube() {
        super("cube", new String[0]);
    }

    @Override
    public Cube convert(JsonElement element, String ... args) {
        return JsonConverterCube.fromJson(element);
    }

    public static Cube fromJson(JsonElement element) {
        if (element instanceof JsonObject) {
            return JsonConverterCube.fromJsonObject((JsonObject)element);
        }
        throw new IllegalArgumentException("JsonConverterCube: could not convert json to cube, json: " + element);
    }

    public static Cube fromJsonObject(JsonObject object) {
        JsonProcessor.ensureValuesExist(object, "min", "max");
        Pos min = JsonConverterPos.fromJson(object.get("min"));
        Pos max = JsonConverterPos.fromJson(object.get("max"));
        return new Cube(min, max);
    }
}

