/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.entity.effect;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.entity.effect.EntityEffect;
import com.builtbroken.mc.framework.entity.effect.EntityEffectHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class IEEPEntityEffect
implements IExtendedEntityProperties {
    public static final String NBT_EFFECTS = "effects";
    public static final String NBT_EFFECT_ID = "effectID";
    protected final Map<String, EntityEffect> effects = new HashMap<String, EntityEffect>();
    public Entity entity;

    public void addEffect(EntityEffect entityEffect) {
        String id = entityEffect.id.toLowerCase();
        EntityEffect original = this.getEffect(id);
        if (original != null) {
            original.merge(entityEffect);
        } else {
            this.effects.put(id, entityEffect);
        }
    }

    public void onWorldTick() {
        Iterator<EntityEffect> it = this.effects.values().iterator();
        while (it.hasNext()) {
            EntityEffect entityEffect = it.next();
            if (!entityEffect.onWorldTick()) continue;
            it.remove();
        }
    }

    public EntityEffect getEffect(String id) {
        if (this.effects.containsKey(id = id.toLowerCase())) {
            return this.effects.get(id);
        }
        return null;
    }

    public void saveNBTData(NBTTagCompound compound) {
        if (!this.effects.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (EntityEffect entityEffect : this.effects.values()) {
                if (entityEffect == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                entityEffect.save(tag);
                if (tag.func_74764_b(NBT_EFFECT_ID)) {
                    Engine.logger().warn("IEEPEntityEffect#saveNBTData(NBT) >> save data for effect '" + entityEffect.id + "' contains tag " + NBT_EFFECT_ID + ", this is used by the save system for the effect's creation ID.");
                }
                tag.func_74778_a(NBT_EFFECT_ID, entityEffect.id);
                list.func_74742_a((NBTBase)tag);
            }
            if (list.func_74745_c() > 0) {
                compound.func_74782_a(NBT_EFFECTS, (NBTBase)list);
            }
        }
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagList list;
        this.effects.clear();
        if (compound.func_74764_b(NBT_EFFECTS) && (list = compound.func_150295_c(NBT_EFFECTS, 10)).func_74745_c() > 0) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                EntityEffect entityEffect;
                NBTTagCompound tag = list.func_150305_b(i);
                String id = tag.func_74779_i(NBT_EFFECT_ID);
                if (id == null || (entityEffect = EntityEffectHandler.create(id, this.entity)) == null) continue;
                entityEffect.load(tag);
            }
        }
    }

    public void init(Entity entity, World world) {
        this.entity = entity;
        for (EntityEffect entityEffect : this.effects.values()) {
            if (entityEffect == null) continue;
            entityEffect.init(entity, world);
        }
    }
}

