/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.energy;

import com.builtbroken.mc.framework.energy.EnergyHandler;
import com.builtbroken.mc.framework.energy.UniversalEnergyHandler;
import com.builtbroken.mc.framework.energy.data.EnergySides;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class UniversalEnergySystem {
    public static final List<EnergyHandler> loadedModules = new ArrayList<EnergyHandler>();
    public static EnergyHandler RF_HANDLER;
    public static final HashMap<Class, EnergyHandler> energyHandlerCache;
    public static final HashMap<Class, EnergyHandler> energyStorageCache;
    private static final HashMap<Object, EnergyHandler> objectHandlerMap;

    public static void register(EnergyHandler module) {
        loadedModules.add(module);
    }

    public static EnergyHandler getHandler(Object handler, ForgeDirection dir) {
        if (UniversalEnergySystem.isHandler(handler, dir)) {
            Class<?> clazz = handler instanceof ItemStack ? ((ItemStack)handler).func_77973_b().getClass() : handler.getClass();
            return energyHandlerCache.get(clazz);
        }
        return null;
    }

    public static boolean isHandler(Object handler, ForgeDirection dir) {
        if (handler != null) {
            Class<?> clazz;
            if (objectHandlerMap.containsKey(handler)) {
                return true;
            }
            Class<?> clazz2 = clazz = handler instanceof ItemStack ? ((ItemStack)handler).func_77973_b().getClass() : handler.getClass();
            if (energyHandlerCache.containsKey(clazz)) {
                return true;
            }
            for (EnergyHandler module : loadedModules) {
                if (!(dir != null ? module.doIsHandler(handler, dir) : module.doIsHandler(handler))) continue;
                if (handler instanceof Item || handler instanceof Block) {
                    objectHandlerMap.put(handler, module);
                }
                energyHandlerCache.put(clazz, module);
                return true;
            }
        }
        return false;
    }

    public static EnergyHandler getContainer(Object handler) {
        if (UniversalEnergySystem.isEnergyContainer(handler)) {
            return energyStorageCache.get(handler.getClass());
        }
        return null;
    }

    public static boolean isEnergyContainer(Object handler) {
        if (handler != null) {
            Class<?> clazz = handler.getClass();
            if (energyStorageCache.containsKey(clazz)) {
                return true;
            }
            for (EnergyHandler module : loadedModules) {
                if (!module.doIsEnergyContainer(handler)) continue;
                energyStorageCache.put(clazz, module);
                return true;
            }
        }
        return false;
    }

    public static boolean canConnect(Object obj, ForgeDirection direction, Object source) {
        EnergyHandler module = UniversalEnergySystem.getHandler(obj, direction);
        return module != null && module.canConnect(obj, direction, source);
    }

    public static double fill(Object handler, ForgeDirection direction, double energy, boolean doReceive) {
        return UniversalEnergySystem.receiveEnergy(handler, direction, energy, doReceive);
    }

    public static double receiveEnergy(Object handler, ForgeDirection direction, double energy, boolean doReceive) {
        EnergyHandler module = UniversalEnergySystem.getHandler(handler, direction);
        if (module != null) {
            return module.receiveEnergy(handler, direction, energy, doReceive);
        }
        return 0.0;
    }

    public static double drain(Object handler, ForgeDirection direction, double energy, boolean doExtract) {
        return UniversalEnergySystem.extractEnergy(handler, direction, energy, doExtract);
    }

    public static double clearEnergy(Object handler, boolean doAction) {
        EnergyHandler module = UniversalEnergySystem.getHandler(handler, null);
        if (module != null) {
            return module.clearEnergy(handler, doAction);
        }
        return 0.0;
    }

    public static double extractEnergy(Object handler, ForgeDirection direction, double energy, boolean doExtract) {
        EnergyHandler module = UniversalEnergySystem.getHandler(handler, direction);
        if (module != null) {
            return module.extractEnergy(handler, direction, energy, doExtract);
        }
        return 0.0;
    }

    public static double extractEnergy(Object handler, double energy, boolean doExtract) {
        double energyLeft = energy;
        for (ForgeDirection dir : ForgeDirection.values()) {
            if (!(energyLeft > 0.0)) break;
            EnergyHandler module = UniversalEnergySystem.getHandler(handler, dir);
            if (module == null) continue;
            energyLeft -= module.extractEnergy(handler, dir, energyLeft, doExtract);
        }
        return energy - energyLeft;
    }

    public static double getPotentialEnergy(Object handler) {
        double energyContained = 0.0;
        for (ForgeDirection dir : ForgeDirection.values()) {
            EnergyHandler module = UniversalEnergySystem.getHandler(handler, dir);
            if (module == null) continue;
            energyContained += module.getEnergy(handler, dir);
        }
        return energyContained;
    }

    public static EnergySides getEnergySided(Object handler) {
        EnergySides sides = new EnergySides();
        for (ForgeDirection dir : ForgeDirection.values()) {
            EnergyHandler module = UniversalEnergySystem.getHandler(handler, dir);
            if (module == null) continue;
            sides.set(dir, module.getEnergy(handler, dir));
        }
        return sides;
    }

    public static double fill(ItemStack itemStack, double joules, boolean doCharge) {
        return UniversalEnergySystem.chargeItem(itemStack, joules, doCharge);
    }

    public static double chargeItem(ItemStack itemStack, double joules, boolean doCharge) {
        EnergyHandler module = UniversalEnergySystem.getHandler(itemStack, null);
        if (module != null) {
            return module.chargeItem(itemStack, joules, doCharge);
        }
        return 0.0;
    }

    public static double drain(ItemStack itemStack, double joules, boolean doDischarge) {
        return UniversalEnergySystem.dischargeItem(itemStack, joules, doDischarge);
    }

    public static double dischargeItem(ItemStack itemStack, double joules, boolean doDischarge) {
        EnergyHandler module = UniversalEnergySystem.getHandler(itemStack, null);
        if (module != null) {
            return module.dischargeItem(itemStack, joules, doDischarge);
        }
        return 0.0;
    }

    public static ItemStack getItemWithCharge(ItemStack itemStack, double energy) {
        EnergyHandler module = UniversalEnergySystem.getHandler(itemStack, null);
        if (module != null) {
            return module.getItemWithCharge(itemStack, energy);
        }
        return itemStack;
    }

    public static double getEnergy(Object obj, ForgeDirection direction) {
        EnergyHandler module = UniversalEnergySystem.getHandler(obj, direction);
        if (module != null) {
            return module.getEnergy(obj, direction);
        }
        return 0.0;
    }

    public static double getMaxEnergy(Object handler, ForgeDirection direction) {
        EnergyHandler module = UniversalEnergySystem.getHandler(handler, direction);
        if (module != null) {
            return module.getMaxEnergy(handler, direction);
        }
        return 0.0;
    }

    public static double getEnergyItem(ItemStack is) {
        EnergyHandler module = UniversalEnergySystem.getHandler(is, null);
        if (module != null) {
            return module.getEnergyItem(is);
        }
        return 0.0;
    }

    public static double getMaxEnergyItem(ItemStack is) {
        EnergyHandler module = UniversalEnergySystem.getHandler(is, null);
        if (module != null) {
            return module.getMaxEnergyItem(is);
        }
        return 0.0;
    }

    public static double setFullCharge(ItemStack is) {
        EnergyHandler module = UniversalEnergySystem.getHandler(is, null);
        if (module != null) {
            return module.setFullCharge(is);
        }
        return 0.0;
    }

    static {
        energyHandlerCache = new HashMap();
        energyStorageCache = new HashMap();
        objectHandlerMap = new HashMap();
        UniversalEnergySystem.register(new UniversalEnergyHandler());
    }
}

