/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.access.global.gui;

import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.framework.access.AccessProfile;
import com.builtbroken.mc.framework.access.AccessUser;
import com.builtbroken.mc.framework.access.global.gui.dialogs.GuiDialogNewProfile;
import com.builtbroken.mc.framework.access.global.gui.frame.main.GuiFrameCenter;
import com.builtbroken.mc.framework.access.global.gui.frame.main.GuiFrameEvents;
import com.builtbroken.mc.framework.access.global.gui.frame.main.ProfileArrayCallback;
import com.builtbroken.mc.framework.access.global.packets.PacketAccessGui;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.prefab.gui.GuiButton2;
import com.builtbroken.mc.prefab.gui.buttons.GuiImageButton;
import com.builtbroken.mc.prefab.gui.components.GuiArray;
import com.builtbroken.mc.prefab.gui.components.GuiComponent;
import com.builtbroken.mc.prefab.gui.components.frame.GuiFrame;
import com.builtbroken.mc.prefab.gui.screen.GuiScreenBase;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;

public class GuiAccessSystem
extends GuiScreenBase
implements IPacketIDReceiver {
    public static int profileRows = 12;
    public GuiButton2 refreshButton;
    public GuiButton2 newProfile;
    public GuiArray profileArray;
    public AccessProfile currentProfile;
    public String[] profileNames;
    public String[] profileIDs;
    public String errorMessage = "";
    public long lastKeepAlivePacket = 0L;
    public int currentProfileIndex = -1;
    public GuiFrame leftFrame;
    public GuiFrame centerFrame;
    public GuiFrame rightFrame;
    public GuiFrameCenter defaultCenterFrame;

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.errorMessage = "";
        this.refreshButton = this.add(GuiImageButton.newRefreshButton(0, 2, 16));
        this.newProfile = (GuiButton2)((Object)this.add(((GuiComponent)((Object)new GuiButton2(1, 20, 16, "New Profile").setWidth(60))).setHeight(18)));
        int sideWidths = 109;
        this.profileArray = this.add(new GuiArray(new ProfileArrayCallback(this), -1, 2, 39, profileRows, 20));
        this.profileArray.setWidth(sideWidths);
        int remainingWidth = this.field_146294_l - sideWidths * 2 - 4;
        this.defaultCenterFrame = new GuiFrameCenter(this, 113, 15);
        this.defaultCenterFrame.setWidth(remainingWidth);
        this.defaultCenterFrame.setHeight(this.field_146295_m - 15);
        this.rightFrame = this.add(new GuiFrameEvents(this, this.defaultCenterFrame.x() + this.defaultCenterFrame.getWidth(), 15));
        this.rightFrame.setWidth(sideWidths);
        this.rightFrame.setHeight(this.field_146295_m - 15);
        this.reloadProfileList();
        this.reloadGroupList();
    }

    public void reloadProfileList() {
        this.currentProfile = null;
        this.currentProfileIndex = -1;
        this.loadCenterFrame(this.defaultCenterFrame, false);
        this.profileArray.reloadEntries();
    }

    protected void reloadGroupList() {
        this.defaultCenterFrame.reloadGroupList();
    }

    @Override
    public void func_146284_a(GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0) {
            this.reloadProfileList();
            PacketAccessGui.doRequest();
        } else if (id == 1) {
            GuiDialogNewProfile guiDialogNewProfile = this.add(new GuiDialogNewProfile(2, 120, 40));
            this.loadCenterFrame(guiDialogNewProfile, false);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.currentProfile != null && System.currentTimeMillis() - this.lastKeepAlivePacket > 1000L) {
            PacketAccessGui.keepAlive(this.currentProfile.getID());
            this.lastKeepAlivePacket = System.currentTimeMillis();
        }
        if (this.centerFrame == null) {
            this.loadCenterFrame(this.defaultCenterFrame, false);
        }
    }

    public void loadProfile(int index) {
        this.currentProfileIndex = index;
        this.currentProfile = null;
        if (this.profileIDs != null && this.currentProfileIndex >= 0 && this.currentProfileIndex < this.profileIDs.length) {
            this.loadCenterFrame(this.defaultCenterFrame, false);
            PacketAccessGui.doRequest(this.profileIDs[this.currentProfileIndex]);
        } else {
            this.currentProfileIndex = -1;
        }
    }

    public void loadCenterFrame(GuiFrame frame, boolean addReturn) {
        if (frame != null) {
            GuiFrame previousOpenedFrame = this.centerFrame;
            if (previousOpenedFrame != null) {
                previousOpenedFrame.hide();
                this.remove(previousOpenedFrame);
            }
            this.centerFrame = frame;
            if (!this.field_146292_n.contains((Object)this.centerFrame)) {
                this.add(this.centerFrame);
            }
            this.centerFrame.initGui();
            this.centerFrame.updatePositions();
            this.centerFrame.show();
            if (addReturn) {
                this.centerFrame.lastOpenedFrame = previousOpenedFrame;
            }
        } else if (this.centerFrame != null) {
            this.centerFrame.hide();
            this.centerFrame.lastOpenedFrame = null;
            this.remove(this.centerFrame);
            this.centerFrame = null;
        }
    }

    public void func_73863_a(int p_73863_1_, int p_73863_2_, float p_73863_3_) {
        this.func_146276_q_();
        Color a = new Color(122, 122, 122, 143);
        Color b = new Color(122, 122, 122, 143);
        this.func_73733_a(0, 15, 113, this.field_146295_m, a.getRGB(), b.getRGB());
        this.func_73728_b(112, 14, this.field_146295_m, Color.BLACK.getRGB());
        this.func_73733_a(0, 0, this.field_146294_l, 15, a.getRGB(), b.getRGB());
        GuiAccessSystem.func_73734_a((int)0, (int)14, (int)this.field_146294_l, (int)15, (int)Color.BLACK.getRGB());
        this.func_73732_a(this.field_146289_q, "Global Access Permission System", this.field_146294_l / 2, 3, 0xFFFFFF);
        String name = "";
        String id = "";
        if (this.profileNames != null && this.currentProfileIndex >= 0 && this.currentProfileIndex < this.profileNames.length) {
            name = this.currentProfile != null ? this.currentProfile.getName() : this.profileNames[this.currentProfileIndex];
            id = this.currentProfile != null ? this.currentProfile.getID() : this.profileIDs[this.currentProfileIndex];
        }
        this.func_73731_b(this.field_146289_q, "Profile: " + name, 122, 20, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, "ID: " + id, 122, 30, 0xFFFFFF);
        if (this.profileNames != null) {
            if (this.errorMessage != null && !this.errorMessage.trim().isEmpty()) {
                if (this.errorMessage.startsWith("error")) {
                    this.func_73732_a(this.field_146289_q, LanguageUtility.getLocal(this.errorMessage), this.field_146294_l / 2, this.field_146295_m / 2, Color.RED.getRGB());
                } else {
                    this.func_73732_a(this.field_146289_q, LanguageUtility.getLocal(this.errorMessage), this.field_146294_l / 2, this.field_146295_m / 2, 0xFFFFFF);
                }
            } else if (this.currentProfileIndex != -1) {
                if (this.currentProfile == null) {
                    this.func_73732_a(this.field_146289_q, LanguageUtility.getLocal("gui.access.waiting.on.server"), this.field_146294_l / 2, this.field_146295_m / 2, 0xFFFFFF);
                }
            } else {
                this.func_73732_a(this.field_146289_q, LanguageUtility.getLocal("gui.access.select.profile"), this.field_146294_l / 2, this.field_146295_m / 2, 0xFFFFFF);
            }
        } else {
            this.func_73732_a(this.field_146289_q, LanguageUtility.getLocal("gui.access.click.refresh"), this.field_146294_l / 2, this.field_146295_m / 2, 0xFFFFFF);
        }
        super.func_73863_a(p_73863_1_, p_73863_2_, p_73863_3_);
    }

    @Override
    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (id == 0) {
            int n = buf.readInt();
            this.profileIDs = new String[n];
            this.profileNames = new String[n];
            for (int i = 0; i < n; ++i) {
                this.profileNames[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
                this.profileIDs[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
                buf.readBoolean();
            }
            this.reloadProfileList();
            return true;
        }
        if (id == 1) {
            if (this.currentProfile == null) {
                this.currentProfile = new AccessProfile(ByteBufUtils.readTag((ByteBuf)buf));
            } else {
                this.currentProfile.load(ByteBufUtils.readTag((ByteBuf)buf));
            }
            this.reloadGroupList();
            return true;
        }
        if (id == 5) {
            this.errorMessage = ByteBufUtils.readUTF8String((ByteBuf)buf);
            return true;
        }
        return false;
    }

    public AccessUser getPlayer() {
        AccessUser user;
        if (this.currentProfile != null && (user = this.currentProfile.getUserAccess((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) != null) {
            return user;
        }
        return new AccessUser((EntityPlayer)Minecraft.func_71410_x().field_71439_g).setTemporary(true);
    }
}

