/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.debug.gui.windows;

import com.builtbroken.mc.client.json.imp.IRenderState;
import com.builtbroken.mc.client.json.render.RenderData;
import com.builtbroken.mc.client.json.render.item.RenderStateItem;
import com.builtbroken.mc.debug.IJsonDebugDisplay;
import com.builtbroken.mc.debug.component.DebugDataCellRenderer;
import com.builtbroken.mc.debug.data.DebugData;
import com.builtbroken.mc.debug.data.DebugJsonData;
import com.builtbroken.mc.debug.data.IJsonDebugData;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class FrameRenderData
extends JFrame {
    JList dataLogList;
    DefaultListModel<IJsonDebugData> debugDataListModel = new DefaultListModel();
    RenderData renderData;

    public FrameRenderData(RenderData renderData) {
        this.renderData = renderData;
        this.setSize(new Dimension(400, 400));
        this.setResizable(false);
        this.setTitle("JSON RenderData debug window");
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        Icon icon = null;
        JPanel panel1 = this.createJsonDataTab();
        tabbedPane.addTab("States", icon, panel1, "Lists all of the render states");
        tabbedPane.setMnemonicAt(0, 49);
        JPanel panel2 = new JPanel();
        tabbedPane.addTab("...", icon, panel2, "not implemented");
        tabbedPane.setMnemonicAt(1, 50);
        this.add((Component)tabbedPane, "Center");
    }

    public void reloadData(String filter) {
        this.debugDataListModel.clear();
        for (Map.Entry<String, IRenderState> entry : this.renderData.renderStatesByName.entrySet()) {
            if (entry.getValue() instanceof IJsonDebugDisplay) {
                String displayName;
                IJsonDebugDisplay display = (IJsonDebugDisplay)((Object)entry.getValue());
                String string = displayName = display.getDisplayName() != null ? display.getDisplayName() : display.toString();
                if (filter != null && !filter.isEmpty() && !displayName.contains(filter)) continue;
                this.debugDataListModel.addElement(new DebugJsonData(display));
                continue;
            }
            String msg = "Key: " + entry.getKey() + " value:" + entry.getValue();
            if (filter != null && !filter.isEmpty() && !msg.contains(filter)) continue;
            this.debugDataListModel.addElement(new DebugData(msg));
        }
    }

    protected JPanel createJsonDataTab() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.dataLogList = new JList<IJsonDebugData>(this.debugDataListModel);
        this.dataLogList.setLayoutOrientation(0);
        this.dataLogList.setCellRenderer(new DebugDataCellRenderer());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.dataLogList);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setPreferredSize(new Dimension(this.getWidth() - 100, this.getHeight() - 100));
        scrollPane.setMinimumSize(new Dimension(this.getWidth() - 100, this.getHeight() - 100));
        panel.add((Component)scrollPane, "Center");
        JPanel menuPanel = new JPanel();
        menuPanel.setMaximumSize(new Dimension(-1, 100));
        Button button = new Button("Reload");
        button.addActionListener(e -> this.reloadData(null));
        menuPanel.add(button);
        JTextField searchBox = new JTextField();
        searchBox.setMinimumSize(new Dimension(200, -1));
        searchBox.setPreferredSize(new Dimension(200, 30));
        searchBox.setToolTipText("Search filter");
        menuPanel.add(searchBox);
        button = new Button("Search");
        button.addActionListener(e -> this.reloadData(searchBox.getText().trim()));
        menuPanel.add(button);
        panel.add((Component)menuPanel, "North");
        return panel;
    }

    public static void main(String ... args) {
        RenderData data = new RenderData(null, "someRender", "item");
        for (int i = 0; i < 30; ++i) {
            RenderStateItem state = new RenderStateItem("item." + i);
            data.add("item." + i, state);
        }
        FrameRenderData gui = new FrameRenderData(data);
        gui.show();
    }
}

