/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.debug.gui.panels.recipes;

import com.builtbroken.mc.debug.data.IJsonDebugData;
import com.builtbroken.mc.debug.gui.panels.imp.PanelDataList;
import com.builtbroken.mc.lib.data.StringComparator;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class TabPanelFurnaceRecipes
extends PanelDataList<FurnaceData> {
    @Override
    protected IJsonDebugData getDataEntryFor(FurnaceData object) {
        return object;
    }

    @Override
    protected void buildData() {
        this.data.clear();
        Map map = FurnaceRecipes.func_77602_a().func_77599_b();
        for (Map.Entry entry : map.entrySet()) {
            this.data.add(new FurnaceData((ItemStack)entry.getKey(), (ItemStack)entry.getValue()));
        }
        Collections.sort(this.data, new FurnaceDataSorter());
    }

    public static class FurnaceDataSorter
    implements Comparator<FurnaceData> {
        protected final StringComparator stringComparator = new StringComparator();

        @Override
        public int compare(FurnaceData o1, FurnaceData o2) {
            String regName1 = Item.field_150901_e.func_148750_c((Object)o1.input.func_77973_b());
            String regName2 = Item.field_150901_e.func_148750_c((Object)o2.input.func_77973_b());
            if (regName1 == null) {
                return -1;
            }
            if (regName2 == null) {
                return 1;
            }
            int result = this.stringComparator.compare(o1.getMod(), o2.getMod());
            if (result == 0) {
                return this.stringComparator.compare(o1.getName(), o2.getName());
            }
            return result;
        }
    }

    public static class FurnaceData
    implements IJsonDebugData {
        ItemStack input;
        ItemStack output;
        float xp;

        public FurnaceData(ItemStack in, ItemStack out) {
            this.input = in;
            this.output = out;
        }

        @Override
        public String buildDebugLineDisplay() {
            return this.asString(this.input) + "  >>>  " + this.asString(this.output);
        }

        protected String asString(ItemStack stack) {
            if (stack != null) {
                if (stack.func_77973_b() != null) {
                    String name = Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()).split(":")[0];
                    return "[" + name + " : " + InventoryUtility.getDisplayName(stack) + "]";
                }
                return "null item";
            }
            return "null stack";
        }

        public String getMod() {
            return InventoryUtility.getModID(this.input);
        }

        public String getName() {
            return InventoryUtility.getDisplayName(this.input);
        }
    }
}

