/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.registry;

import com.builtbroken.mc.core.registry.ModManager;
import com.builtbroken.mc.core.registry.implement.IRegistryInit;
import com.builtbroken.mc.lib.helper.ReflectionUtility;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;

public class CommonRegistryProxy {
    public void registerBlock(ModManager manager, String name, String modPrefix, Block block, Class<? extends ItemBlock> itemBlock) {
        GameRegistry.registerBlock((Block)block, itemBlock != null ? itemBlock : ItemBlock.class, (String)name);
        if (block.func_149739_a() == null || block.func_149739_a().contains("null")) {
            block.func_149663_c((modPrefix != null ? modPrefix : "") + name);
        }
    }

    public void registerItem(ModManager manager, String name, String modPrefix, Item item) {
        GameRegistry.registerItem((Item)item, (String)name);
        if (modPrefix != null && (item.field_77774_bZ == null || item.field_77774_bZ.isEmpty())) {
            item.func_77655_b(modPrefix + name);
        }
    }

    public void registerTileEntity(String name, String prefix, Block block, TileEntity tile) {
        try {
            GameRegistry.registerTileEntity(tile.getClass(), (String)(prefix + name));
        }
        catch (IllegalArgumentException exception) {
            if (exception.getMessage().contains("Duplicate id:")) {
                try {
                    Class c;
                    Field field = ReflectionUtility.getMCField(TileEntity.class, "field_145855_i", "nameToClassMap");
                    field.setAccessible(true);
                    Map map = (Map)field.get(null);
                    if (map.containsKey(name) && (c = (Class)map.get(name)) != tile.getClass()) {
                        throw new RuntimeException("IDs matched but classes for entities did not. This is either a code error or conflict between two mods.", exception);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to check for duplicate tile IDs matching", e);
                }
            }
            throw exception;
        }
    }

    public void registerDummyRenderer(Class<? extends TileEntity> clazz) {
    }

    public void onRegistry(Object object) {
        if (object instanceof IRegistryInit) {
            ((IRegistryInit)object).onRegistered();
        }
    }
}

