/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.network.packet.callback.chunk;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.packet.callback.chunk.PacketRequestData;
import com.builtbroken.mc.lib.world.map.block.ExtendedBlockDataManager;
import com.builtbroken.mc.lib.world.map.data.ChunkData;
import com.builtbroken.mc.lib.world.map.data.s.ChunkDataShort;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;

public class PacketSendData
extends PacketRequestData {
    ChunkData data = null;

    public PacketSendData() {
    }

    public PacketSendData(int dim, int x, int z, int type, ChunkData data) {
        super(dim, x, z, type);
        this.data = data;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        super.encodeInto(ctx, buffer);
        this.data.writeBytes(buffer);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        super.decodeInto(ctx, buffer);
        if (this.type == 0) {
            this.data = new ChunkDataShort(this.x, this.z);
        } else if (Engine.runningAsDev) {
            Engine.logger().error("ChunkPacketHandler: Failed to ID chunk type[" + this.type + "] while decoding chunk data packet");
        }
        if (this.data != null) {
            this.data.readBytes(buffer);
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        if (this.data != null && this.dim == player.field_70170_p.field_73011_w.field_76574_g && this.type == 0) {
            ExtendedBlockDataManager.CLIENT.chunks.put(this.data.position, (ChunkDataShort)this.data);
        }
    }
}

