/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.network.netty;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.data.IPacket;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.netty.PacketChannelHandler;
import com.builtbroken.mc.core.network.netty.PacketHandler;
import com.builtbroken.mc.core.network.packet.PacketEntity;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.framework.mod.loadable.AbstractLoadable;
import com.builtbroken.mc.lib.helper.wrapper.ByteBufWrapper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import java.util.EnumMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketManager
extends AbstractLoadable {
    public final String channel;
    protected EnumMap<Side, FMLEmbeddedChannel> channelEnumMap;
    public PacketHandler packetHandler;
    public PacketChannelHandler packetChannelHandler;

    public PacketManager(String channel) {
        this.channel = channel;
    }

    @Deprecated
    public static void writeData(ByteBuf data, Object ... sendData) {
        new ByteBufWrapper.ByteBufWrapper(data).$less$less$less(sendData);
    }

    @Deprecated
    public static PacketType getPacketFor(Object obj) {
        if (obj instanceof TileEntity) {
            return new PacketTile((TileEntity)obj, new Object[0]);
        }
        if (obj instanceof Entity) {
            return new PacketEntity((Entity)obj, new Object[0]);
        }
        return null;
    }

    public Packet toMCPacket(IPacket packet) {
        return this.channelEnumMap.get(FMLCommonHandler.instance().getEffectiveSide()).generatePacketFrom((Object)packet);
    }

    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        this.packetHandler = new PacketHandler();
        this.packetChannelHandler = new PacketChannelHandler();
        this.channelEnumMap = NetworkRegistry.INSTANCE.newChannel(this.channel, new ChannelHandler[]{this.packetHandler, this.packetChannelHandler});
    }

    @Override
    public void postInit() {
    }

    public void sendToPlayer(IPacket packet, EntityPlayerMP player) {
        if (this.channelEnumMap != null) {
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
            this.channelEnumMap.get(Side.SERVER).writeAndFlush((Object)packet);
        } else {
            Engine.error("Packet sent to player[" + player + "]");
        }
    }

    public void sendToAllInDimension(IPacket packet, int dimId) {
        if (this.channelEnumMap != null) {
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimId);
            this.channelEnumMap.get(Side.SERVER).writeAndFlush((Object)packet);
        } else {
            Engine.error("Packet sent to dim[" + dimId + "]");
        }
    }

    public void sendToAllInDimension(IPacket packet, World world) {
        this.sendToAllInDimension(packet, world.field_73011_w.field_76574_g);
    }

    public void sendToAll(IPacket packet) {
        if (this.channelEnumMap != null) {
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
            this.channelEnumMap.get(Side.SERVER).writeAndFlush((Object)packet);
        } else {
            Engine.error("Packet sent to all");
        }
    }

    public void sendToAllAround(IPacket message, NetworkRegistry.TargetPoint point) {
        if (this.channelEnumMap != null) {
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
            this.channelEnumMap.get(Side.SERVER).writeAndFlush((Object)message);
        } else {
            Engine.error("Packet sent to target point: " + point);
        }
    }

    public void sendToAllAround(IPacket message, IWorldPosition point, double range) {
        this.sendToAllAround(message, point.oldWorld(), point.x(), point.y(), point.z(), range);
    }

    public void sendToAllAround(IPacket message, World world, IPos3D point, double range) {
        this.sendToAllAround(message, world, point.x(), point.y(), point.z(), range);
    }

    public void sendToAllAround(IPacket message, TileEntity tile) {
        this.sendToAllAround(message, tile, 64.0);
    }

    public void sendToAllAround(IPacket message, TileEntity tile, double range) {
        this.sendToAllAround(message, tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, range);
    }

    public void sendToAllAround(IPacket message, World world, double x, double y, double z, double range) {
        if (world != null) {
            this.sendToAllAround(message, new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, x, y, z, range));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void sendToServer(IPacket packet) {
        if (this.channelEnumMap != null) {
            this.channelEnumMap.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
            this.channelEnumMap.get(Side.CLIENT).writeAndFlush((Object)packet);
        } else {
            Engine.error("Packet sent to server");
        }
    }
}

