/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.deps;

public class Version {
    public final int major;
    public final int minor;
    public final int revis;
    public final int build;

    public Version(int major, int minor, int revis, int build) {
        this.major = major;
        this.minor = minor;
        this.revis = revis;
        this.build = build;
    }

    public Version(String version) {
        if (version == null || version.isEmpty()) {
            throw new IllegalArgumentException("Version can't be created with an empty or null string value");
        }
        int firstDot = version.indexOf(".");
        int secondDot = version.indexOf(".", firstDot + 1);
        int thirdDot = version.indexOf("b", secondDot + 1);
        if (firstDot < 0 || secondDot < 0 || thirdDot < 0) {
            throw new IllegalArgumentException("Invalid version string " + version);
        }
        try {
            this.major = Integer.parseInt(version.substring(0, firstDot));
            this.minor = Integer.parseInt(version.substring(firstDot + 1, secondDot));
            this.revis = Integer.parseInt(version.substring(secondDot + 1, thirdDot));
            this.build = Integer.parseInt(version.substring(thirdDot + 1, version.length()));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse version string '" + version + "'", e);
        }
    }

    public boolean isNewer(Version v) {
        if (v.major < this.major) {
            return false;
        }
        if (v.minor < this.minor) {
            return false;
        }
        if (v.revis < this.revis) {
            return false;
        }
        return v.build > this.build;
    }

    public String toString() {
        if (this.build == -1) {
            return this.major + "." + this.minor + "." + this.revis;
        }
        return this.major + "." + this.minor + "." + this.revis + "b" + this.build;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            return ((Version)obj).major == this.major && ((Version)obj).minor == this.minor && ((Version)obj).revis == this.revis && ((Version)obj).build == this.build;
        }
        return false;
    }
}

