/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.content.blast.emp;

import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.edit.BlockEditResult;
import com.builtbroken.mc.api.energy.IEMReceptiveDevice;
import com.builtbroken.mc.core.content.blast.emp.BlastEMP;
import com.builtbroken.mc.lib.world.edit.BlockEdit;
import net.minecraft.tileentity.TileEntity;

public class EmpEdit
extends BlockEdit {
    final double power;
    final double distance;
    final BlastEMP source;

    public EmpEdit(IWorldPosition vec, BlastEMP source, double distance, double power) {
        super(vec);
        this.source = source;
        this.distance = distance;
        this.power = power;
    }

    @Override
    public boolean hasChanged() {
        return true;
    }

    @Override
    public BlockEditResult place() {
        if (this.world != null) {
            if (this.isChunkLoaded()) {
                return this.doPlace();
            }
            return BlockEditResult.CHUNK_UNLOADED;
        }
        return BlockEditResult.NULL_WORLD;
    }

    @Override
    protected BlockEditResult doPlace() {
        TileEntity tile = this.getTileEntity();
        if (tile instanceof IEMReceptiveDevice) {
            ((IEMReceptiveDevice)tile).onElectromagneticRadiationApplied(this.source, this.distance, this.power, true);
            return BlockEditResult.PLACED;
        }
        return BlockEditResult.PREV_BLOCK_CHANGED;
    }
}

