/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.commands.permissions;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.commands.permissions.GroupProfileHandler;
import com.builtbroken.mc.core.commands.permissions.PermissionsRegistry;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Iterator;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandNotFoundException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerSelector;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;

public class PermissionsCommandManager
extends ServerCommandManager {
    public boolean hasPermissionForCommand(ICommandSender sender, ICommand command, String[] args) {
        return sender instanceof EntityPlayer && PermissionsCommandManager.isPlayerOpped((EntityPlayer)sender) || GroupProfileHandler.GLOBAL.canExecuteCommand(sender, command, args);
    }

    public static boolean isPlayerOpped(EntityPlayer player) {
        return player instanceof EntityPlayerMP && PermissionsCommandManager.isPlayerOpped((EntityPlayerMP)player);
    }

    public static boolean isPlayerOpped(EntityPlayerMP player) {
        return player.field_71133_b.func_71203_ab().func_152596_g(player.func_146103_bH()) && player.field_71133_b.func_71203_ab().func_152603_m().func_152683_b((Object)player.func_146103_bH()) != null;
    }

    public ICommand func_71560_a(ICommand command) {
        if (command != null && command.func_71517_b() != null) {
            PermissionsRegistry.handle(command, command.func_71517_b());
            return super.func_71560_a(command);
        }
        return command;
    }

    public int func_71556_a(ICommandSender sender, String cmd) {
        if ((cmd = cmd.trim()).startsWith("/")) {
            cmd = cmd.substring(1);
        }
        String[] args = cmd.split(" ");
        String command_name = args[0];
        args = PermissionsCommandManager.dropFirstString(args);
        ICommand icommand = (ICommand)this.func_71555_a().get(command_name);
        int usernameIndex = this.getUsernameIndex(icommand, args);
        int j = 0;
        try {
            if (icommand == null) {
                throw new CommandNotFoundException();
            }
            if (this.hasPermissionForCommand(sender, icommand, args)) {
                CommandEvent event = new CommandEvent(icommand, sender, args);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    if (event.exception != null) {
                        throw event.exception;
                    }
                    return 1;
                }
                if (usernameIndex > -1) {
                    EntityPlayerMP[] players = PlayerSelector.func_82380_c((ICommandSender)sender, (String)args[usernameIndex]);
                    String s2 = args[usernameIndex];
                    for (EntityPlayerMP entityplayermp : players) {
                        args[usernameIndex] = entityplayermp.func_70005_c_();
                        try {
                            icommand.func_71515_b(sender, args);
                            ++j;
                        }
                        catch (CommandException commandexception1) {
                            ChatComponentTranslation chatcomponenttranslation1 = new ChatComponentTranslation(commandexception1.getMessage(), commandexception1.func_74844_a());
                            chatcomponenttranslation1.func_150256_b().func_150238_a(EnumChatFormatting.RED);
                            sender.func_145747_a((IChatComponent)chatcomponenttranslation1);
                        }
                    }
                    args[usernameIndex] = s2;
                } else {
                    try {
                        icommand.func_71515_b(sender, args);
                        ++j;
                    }
                    catch (CommandException commandexception) {
                        ChatComponentTranslation chatcomponenttranslation = new ChatComponentTranslation(commandexception.getMessage(), commandexception.func_74844_a());
                        chatcomponenttranslation.func_150256_b().func_150238_a(EnumChatFormatting.RED);
                        sender.func_145747_a((IChatComponent)chatcomponenttranslation);
                    }
                }
            } else {
                ChatComponentTranslation chatcomponenttranslation2 = new ChatComponentTranslation("commands.generic.permission", new Object[0]);
                chatcomponenttranslation2.func_150256_b().func_150238_a(EnumChatFormatting.RED);
                sender.func_145747_a((IChatComponent)chatcomponenttranslation2);
            }
        }
        catch (WrongUsageException wrongusageexception) {
            ChatComponentTranslation chatcomponenttranslation = new ChatComponentTranslation("commands.generic.usage", new Object[]{new ChatComponentTranslation(wrongusageexception.getMessage(), wrongusageexception.func_74844_a())});
            chatcomponenttranslation.func_150256_b().func_150238_a(EnumChatFormatting.RED);
            sender.func_145747_a((IChatComponent)chatcomponenttranslation);
        }
        catch (CommandException commandexception2) {
            ChatComponentTranslation chatcomponenttranslation = new ChatComponentTranslation(commandexception2.getMessage(), commandexception2.func_74844_a());
            chatcomponenttranslation.func_150256_b().func_150238_a(EnumChatFormatting.RED);
            sender.func_145747_a((IChatComponent)chatcomponenttranslation);
        }
        catch (Throwable throwable) {
            ChatComponentTranslation chatcomponenttranslation = new ChatComponentTranslation("commands.generic.exception", new Object[0]);
            chatcomponenttranslation.func_150256_b().func_150238_a(EnumChatFormatting.RED);
            sender.func_145747_a((IChatComponent)chatcomponenttranslation);
            Engine.logger().error("Failed to process command: '" + cmd + "'", throwable);
        }
        return j;
    }

    public List func_71557_a(ICommandSender sender) {
        List arraylist = super.func_71557_a(sender);
        if (arraylist != null) {
            Iterator it = arraylist.iterator();
            while (it.hasNext()) {
                ICommand obj = (ICommand)it.next();
                if (obj.func_71517_b() != null && obj.func_71518_a(sender) != null) continue;
                it.remove();
            }
        }
        return arraylist;
    }

    private int getUsernameIndex(ICommand command, String[] args) {
        if (command == null) {
            return -1;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!command.func_82358_a(args, i) || !PlayerSelector.func_82377_a((String)args[i])) continue;
            return i;
        }
        return -1;
    }

    private static String[] dropFirstString(String[] p_71559_0_) {
        String[] astring1 = new String[p_71559_0_.length - 1];
        for (int i = 1; i < p_71559_0_.length; ++i) {
            astring1[i - 1] = p_71559_0_[i];
        }
        return astring1;
    }
}

