/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.commands.json;

import com.builtbroken.jlib.lang.EnglishLetters;
import com.builtbroken.jlib.type.Pair;
import com.builtbroken.mc.core.commands.prefab.SubCommand;
import com.builtbroken.mc.framework.json.JsonContentLoader;
import com.builtbroken.mc.framework.json.conversion.data.mc.JsonConverterNBT;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class CommandJsonRecipe
extends SubCommand {
    public CommandJsonRecipe() {
        super("recipe");
    }

    @Override
    public boolean handleEntityPlayerCommand(EntityPlayer player, String[] args) {
        return this.handleConsoleCommand((ICommandSender)player, args);
    }

    @Override
    public boolean handleConsoleCommand(ICommandSender sender, String[] args) {
        if (args != null && args.length > 0 && !"help".equalsIgnoreCase(args[0]) && (args[0].equals("generate") || args[0].equals("gen")) && args.length > 1) {
            block29: {
                String entryID = args[1];
                ItemStack stack = null;
                if (stack != null) {
                    List<IRecipe> recipes;
                    List<IRecipe> list = recipes = entryID.contains("#") ? InventoryUtility.getRecipesWithOutput(stack) : InventoryUtility.getRecipesWithOutput(stack.func_77973_b());
                    if (recipes != null) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText("Found " + recipes.size() + " for '" + entryID + "' saving to external json file"));
                        File writeFile = new File(JsonContentLoader.INSTANCE.externalContentFolder.getParent(), "json-gen/" + (entryID + "-recipes.json").replace(":", "_"));
                        if (!writeFile.getParentFile().exists()) {
                            writeFile.getParentFile().mkdirs();
                        }
                        try {
                            JsonObject object = new JsonObject();
                            int index = 0;
                            for (IRecipe recipe : recipes) {
                                try {
                                    if (recipe instanceof ShapedOreRecipe) {
                                        int width = 0;
                                        int height = 0;
                                        Object[] recipeItems = null;
                                        Field field = ShapedOreRecipe.class.getDeclaredField("input");
                                        field.setAccessible(true);
                                        recipeItems = (Object[])field.get(recipe);
                                        field = ShapedOreRecipe.class.getDeclaredField("width");
                                        field.setAccessible(true);
                                        width = field.getInt(recipe);
                                        field = ShapedOreRecipe.class.getDeclaredField("height");
                                        field.setAccessible(true);
                                        height = field.getInt(recipe);
                                        Pair<String, HashMap<String, JsonElement>> itemSet = this.generateItemData(recipeItems, width, height);
                                        if (itemSet != null) {
                                            JsonObject recipeObject = new JsonObject();
                                            recipeObject.add("type", (JsonElement)new JsonPrimitive("shaped"));
                                            recipeObject.add("output", this.toItemJson(recipe.func_77571_b()));
                                            recipeObject.add("grid", (JsonElement)new JsonPrimitive((String)itemSet.left()));
                                            JsonObject itemEntry = new JsonObject();
                                            for (Map.Entry entry : ((HashMap)itemSet.right()).entrySet()) {
                                                itemEntry.add((String)entry.getKey(), (JsonElement)entry.getValue());
                                            }
                                            recipeObject.add("items", (JsonElement)itemEntry);
                                            object.add("craftingGridRecipe:" + index++, (JsonElement)recipeObject);
                                            continue;
                                        }
                                        sender.func_145747_a((IChatComponent)new ChatComponentText("Failed to map recipe items for '" + recipe + "'"));
                                        continue;
                                    }
                                    if (recipe instanceof ShapedRecipes) {
                                        Pair<String, HashMap<String, JsonElement>> itemSet = this.generateItemData(((ShapedRecipes)recipe).field_77574_d, ((ShapedRecipes)recipe).field_77576_b, ((ShapedRecipes)recipe).field_77577_c);
                                        if (itemSet != null) {
                                            JsonObject recipeObject = new JsonObject();
                                            recipeObject.add("type", (JsonElement)new JsonPrimitive("shaped"));
                                            recipeObject.add("output", this.toItemJson(recipe.func_77571_b()));
                                            recipeObject.add("grid", (JsonElement)new JsonPrimitive((String)itemSet.left()));
                                            JsonObject itemEntry = new JsonObject();
                                            for (Map.Entry entry : ((HashMap)itemSet.right()).entrySet()) {
                                                itemEntry.add((String)entry.getKey(), (JsonElement)entry.getValue());
                                            }
                                            recipeObject.add("items", (JsonElement)itemEntry);
                                            object.add("craftingGridRecipe:" + index++, (JsonElement)recipeObject);
                                            continue;
                                        }
                                        sender.func_145747_a((IChatComponent)new ChatComponentText("Failed to map recipe items for '" + recipe + "'"));
                                        continue;
                                    }
                                    sender.func_145747_a((IChatComponent)new ChatComponentText("Failed to ID recipe type of '" + recipe + "'"));
                                }
                                catch (Exception e) {
                                    sender.func_145747_a((IChatComponent)new ChatComponentText("Error processing recipe '" + recipe + "', see logs for details."));
                                    e.printStackTrace();
                                }
                            }
                            if (object.entrySet().size() <= 0) break block29;
                            Gson gson = new GsonBuilder().setPrettyPrinting().create();
                            try (FileWriter file = new FileWriter(writeFile);){
                                file.write(gson.toJson((JsonElement)object));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        sender.func_145747_a((IChatComponent)new ChatComponentText("Failed to locate recipes for '" + entryID + "'"));
                    }
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("Failed to locate entry for '" + entryID + "'"));
                }
            }
            return true;
        }
        return this.handleHelp(sender, args);
    }

    protected Pair<String, HashMap<String, JsonElement>> generateItemData(Object[] recipeItems, int width, int height) {
        HashMap<String, JsonElement> items = new HashMap<String, JsonElement>();
        HashMap<String, String> itemToKey = new HashMap<String, String>();
        String grid = "";
        int c = 0;
        int w = 0;
        int h = 0;
        boolean upper = false;
        if (recipeItems != null) {
            for (Object obj : recipeItems) {
                if (c > EnglishLetters.values().length) {
                    c = 0;
                    if (!upper) {
                        upper = true;
                    } else {
                        return null;
                    }
                }
                if (obj != null) {
                    if (c < EnglishLetters.values().length) {
                        JsonElement element = this.toItemJson(obj);
                        String json = element.toString();
                        if (itemToKey.containsKey(json)) {
                            String key = (String)itemToKey.get(json);
                            grid = grid + key;
                        } else {
                            String ch = EnglishLetters.values()[c].name();
                            ch = upper ? ch : ch.toLowerCase();
                            items.put(ch, element);
                            itemToKey.put(json, ch);
                            grid = grid + ch;
                            ++c;
                        }
                    }
                } else {
                    grid = grid + " ";
                }
                if (w++ < width - 1) continue;
                w = 0;
                if (++h >= height) continue;
                grid = grid + ",";
            }
            return new Pair((Object)grid, items);
        }
        return null;
    }

    protected JsonElement toItemJson(Object output) {
        if (output instanceof String) {
            return new JsonPrimitive((String)output);
        }
        if (output instanceof Block) {
            return new JsonPrimitive("block@" + Block.field_149771_c.func_148750_c(output));
        }
        if (output instanceof Item) {
            return new JsonPrimitive("item@" + Item.field_150901_e.func_148750_c(output));
        }
        if (output instanceof ItemStack) {
            if (((ItemStack)output).func_77973_b() instanceof ItemBlock) {
                if (((ItemStack)output).func_77978_p() != null) {
                    JsonObject object = new JsonObject();
                    object.add("type", (JsonElement)new JsonPrimitive("block"));
                    object.add("value", (JsonElement)new JsonPrimitive(Block.field_149771_c.func_148750_c((Object)((ItemBlock)((ItemStack)output).func_77973_b()).field_150939_a)));
                    object.add("meta", (JsonElement)new JsonPrimitive((Number)((ItemStack)output).func_77960_j()));
                    object.add("nbt", JsonConverterNBT.toJson(((ItemStack)output).func_77978_p()));
                    return object;
                }
                return new JsonPrimitive("block@" + Block.field_149771_c.func_148750_c((Object)((ItemBlock)((ItemStack)output).func_77973_b()).field_150939_a) + "#" + ((ItemStack)output).func_77960_j());
            }
            if (((ItemStack)output).func_77978_p() != null) {
                JsonObject object = new JsonObject();
                object.add("type", (JsonElement)new JsonPrimitive("item"));
                object.add("value", (JsonElement)new JsonPrimitive(Item.field_150901_e.func_148750_c((Object)((ItemStack)output).func_77973_b())));
                object.add("meta", (JsonElement)new JsonPrimitive((Number)((ItemStack)output).func_77960_j()));
                object.add("nbt", JsonConverterNBT.toJson(((ItemStack)output).func_77978_p()));
                return object;
            }
            return new JsonPrimitive("item@" + Item.field_150901_e.func_148750_c((Object)((ItemStack)output).func_77973_b()) + "#" + ((ItemStack)output).func_77960_j());
        }
        if (output instanceof ArrayList) {
            ArrayList list = (ArrayList)output;
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (Object o : list) {
                int[] ids;
                if (!(o instanceof ItemStack)) continue;
                for (int id : ids = OreDictionary.getOreIDs((ItemStack)((ItemStack)o))) {
                    String name = OreDictionary.getOreName((int)id);
                    if (map.containsKey(name)) {
                        map.put(name, (Integer)map.get(name) + 1);
                        continue;
                    }
                    map.put(name, 1);
                }
            }
            String name = "";
            int n = 0;
            for (Map.Entry entry : map.entrySet()) {
                if ((Integer)entry.getValue() <= n) continue;
                n = (Integer)entry.getValue();
                name = (String)entry.getKey();
            }
            return new JsonPrimitive("ore@" + name);
        }
        System.out.println("Could not ID '" + output + "'");
        return new JsonPrimitive("???");
    }

    @Override
    public void getHelpOutput(ICommandSender sender, List<String> items) {
        items.add("generate mod:itemName - generates json recipes using the items existing recipes");
        items.add("generate item@mod:itemName - forces to use item list");
        items.add("generate block@mod:itemName - forces to use block list");
    }
}

