/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.asm.template;

import com.builtbroken.mc.core.EngineCoreMod;
import com.builtbroken.mc.core.asm.template.TemplateManager;
import com.builtbroken.mc.lib.asm.ASMHelper;
import com.builtbroken.mc.lib.asm.ObfMapping;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class InjectionTemplate {
    public final String className;
    public final List<String> interfaces;
    private boolean init = false;
    private boolean failedToLoadClass = false;
    public ArrayList<MethodNode> methodImplementations = new ArrayList();

    public static InjectionTemplate getTemplate(String key) {
        return TemplateManager.templates.containsKey(key) ? TemplateManager.templates.get(key) : null;
    }

    public InjectionTemplate(String className, List<String> interfaces) {
        this.className = className;
        this.interfaces = interfaces;
        EngineCoreMod.logger.info("TemplateManager: Loading template for " + className + " as long as interfaces " + interfaces + " exist");
    }

    public boolean patch(ClassNode cnode, boolean injectConstructor) {
        if (this.init()) {
            return false;
        }
        for (String interfaceName : this.interfaces) {
            String interfaceByteName = interfaceName.replace(".", "/");
            if (!cnode.interfaces.contains(interfaceByteName)) {
                cnode.interfaces.add(interfaceByteName);
                continue;
            }
            return false;
        }
        boolean changed = false;
        LinkedList<String> names = new LinkedList<String>();
        for (MethodNode method : cnode.methods) {
            ObfMapping m = new ObfMapping(cnode.name, method.name, method.desc).toRuntime();
            names.add(m.s_name + m.s_desc);
        }
        for (MethodNode impl : this.methodImplementations) {
            if (impl.name.equals("<init>") && !injectConstructor || names.contains(impl.name + impl.desc)) continue;
            ObfMapping mapping = new ObfMapping(cnode.name, impl.name, impl.desc).toRuntime();
            MethodNode copy = new MethodNode(impl.access, mapping.s_name, mapping.s_desc, impl.signature, impl.exceptions == null ? null : impl.exceptions.toArray(new String[0]));
            ASMHelper.copy(impl, copy);
            cnode.methods.add(impl);
            changed = true;
        }
        return changed;
    }

    private boolean init() {
        if (!this.init) {
            this.init = true;
            try {
                ClassNode cnode = ASMHelper.createClassNode(((LaunchClassLoader)InjectionTemplate.class.getClassLoader()).getClassBytes(this.className.replace('/', '.')));
                for (MethodNode method : cnode.methods) {
                    this.methodImplementations.add(method);
                    method.desc = new ObfMapping((String)cnode.name, (String)method.name, (String)method.desc).toRuntime().s_desc;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.failedToLoadClass = true;
            }
        }
        return this.failedToLoadClass;
    }
}

