/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.codegen.processor;

import com.builtbroken.mc.codegen.Main;
import com.builtbroken.mc.codegen.data.BuildData;
import com.builtbroken.mc.codegen.template.Template;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class Processor {
    protected final HashMap<String, Template> templateMap = new HashMap();
    public final String annotationKey;
    public final String templateAnnotationKey;
    public final String classToExtend;

    public Processor(String annotationKey, String templateAnnotationKey, String classToExtend) {
        this.annotationKey = annotationKey;
        this.templateAnnotationKey = templateAnnotationKey;
        this.classToExtend = classToExtend;
    }

    public void initialized(File mainDirectory, HashMap<String, String> arguments) {
    }

    public abstract void handleFile(File var1, BuildData var2, String var3) throws IOException;

    public void finalize(File outputFolder) {
    }

    protected void build(File outputFolder, List<Template> templates, BuildData buildData, String spacer) {
        StringBuilder builder = new StringBuilder();
        builder.append("//=======================================================\n");
        builder.append("//DISCLAIMER: THIS IS A GENERATED CLASS FILE\n");
        builder.append("//THUS IS PROVIDED 'AS-IS' WITH NO WARRANTY\n");
        builder.append("//FUNCTIONALITY CAN NOT BE GUARANTIED IN ANY WAY \n");
        builder.append("//USE AT YOUR OWN RISK \n");
        builder.append("//-------------------------------------------------------\n");
        builder.append("//Built on: ");
        builder.append(System.getProperty("user.name"));
        builder.append("\n");
        builder.append("//=======================================================\n");
        if (buildData.outputClassName.contains(".")) {
            if (!buildData.outputClassName.startsWith(".")) {
                buildData.outputClassPackage = "";
            }
            buildData.outputClassPackage = buildData.outputClassPackage + buildData.outputClassName.substring(0, buildData.outputClassName.lastIndexOf("."));
            buildData.outputClassName = buildData.outputClassName.substring(buildData.outputClassName.lastIndexOf(".") + 1, buildData.outputClassName.length());
        } else {
            buildData.outputClassPackage = buildData.classPackage;
        }
        builder.append("package " + buildData.outputClassPackage + ";\n");
        builder.append("\n");
        this.createImports(builder, templates, buildData);
        builder.append("\n");
        this.createClassHeader(builder, templates, buildData);
        builder.append("\n{\n");
        this.createConstructor(builder, templates, buildData);
        this.createBody(builder, templates, buildData);
        builder.append("}");
        try {
            File outFile = new File(outputFolder, buildData.outputClassPackage.replace(".", File.separator) + File.separator + buildData.outputClassName + ".java");
            Main.out(spacer + "  Writing file to disk, file = " + outFile);
            if (!outFile.getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
                Main.out(spacer + "   Created directories");
            } else if (outFile.exists()) {
                Main.out(spacer + "   Overriding existing file");
            }
            FileWriter fileWriter = new FileWriter(outFile);
            fileWriter.write(builder.toString());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception e) {
            Main.error(spacer + "    Error writing file", e);
            System.exit(1);
        }
    }

    protected void createImports(StringBuilder builder, List<Template> templates, BuildData buildData) {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add(buildData.classPackage + "." + buildData.className);
        this.collectImports(imports, templates, buildData);
        ArrayList<String> ignored = new ArrayList<String>();
        this.collectIgnoredImports(ignored, templates, buildData);
        for (String imp : imports) {
            if (ignored.contains(imp)) continue;
            builder.append("import ");
            builder.append(imp);
            builder.append(";\n");
        }
    }

    protected void collectImports(List<String> imports, List<Template> templates, BuildData buildData) {
        for (Template template : templates) {
            if (template == null) continue;
            List<String> importsFromProcessor = template.getImports();
            for (String imp : importsFromProcessor) {
                if (imports.contains(imp)) continue;
                imports.add(imp);
            }
        }
    }

    protected void collectIgnoredImports(List<String> imports, List<Template> templates, BuildData buildData) {
    }

    protected void createClassHeader(StringBuilder builder, List<Template> templates, BuildData buildData) {
        builder.append("public class " + buildData.outputClassName + " extends " + this.classToExtend);
        ArrayList<String> interfaces = new ArrayList<String>();
        for (Template template : templates) {
            List<String> interfacesFromProcessor = template.getInterfaces();
            for (String imp : interfacesFromProcessor) {
                if (interfaces.contains(imp)) continue;
                interfaces.add(imp);
            }
        }
        if (!interfaces.isEmpty()) {
            builder.append(" implements ");
            for (int i = 0; i < interfaces.size(); ++i) {
                builder.append((String)interfaces.get(i));
                if (i == interfaces.size() - 1) continue;
                builder.append(", ");
            }
        }
    }

    protected void createConstructor(StringBuilder builder, List<Template> templates, BuildData buildData) {
    }

    protected void createBody(StringBuilder builder, List<Template> templates, BuildData buildData) {
        for (Template template : templates) {
            String[] fields;
            if (template.fieldBody == null) continue;
            builder.append("\t//Fields from ");
            builder.append(template.getKey());
            builder.append("\n");
            for (String field : fields = template.fieldBody.split(";")) {
                if (field.isEmpty()) continue;
                builder.append("\t");
                builder.append(field.trim());
                builder.append(";\n");
            }
        }
        for (Template template : templates) {
            if (template.methodBody == null) continue;
            builder.append("\t//============================\n\t//==Methods:");
            builder.append(template.getKey());
            builder.append("\n\t//============================\n");
            builder.append("\n");
            builder.append(template.methodBody);
            builder.append("\n");
        }
    }

    public void loadTemplates(File directory, int depth) {
        File[] files;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i <= depth; ++i) {
            builder.append("  ");
        }
        String spacer = builder.toString();
        Main.out(spacer + "*Directory: " + directory.getName());
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                this.loadTemplates(file, ++depth);
                continue;
            }
            Main.out("");
            Main.out(spacer + "--File: " + file.getName());
            Main.out(spacer + " |------------------------->");
            Template template = new Template(this.templateAnnotationKey, this.classToExtend);
            try {
                template = template.loadFile(file, spacer + " | ");
                if (template != null && template.isValid()) {
                    this.templateMap.put(template.getKey(), template);
                }
            }
            catch (Exception e) {
                Main.error("Unexpected error while loading template from file " + file, e);
            }
            Main.out(spacer + " |------------------------->");
        }
    }
}

