/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.client.json.texture;

import com.builtbroken.mc.client.json.texture.TextureData;
import com.builtbroken.mc.framework.json.processors.JsonProcessor;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class TextureJsonProcessor
extends JsonProcessor<TextureData> {
    @Override
    public String getMod() {
        return "voltzengine";
    }

    @Override
    public String getJsonKey() {
        return "texture";
    }

    @Override
    public String getLoadOrder() {
        return null;
    }

    @Override
    protected TextureData process(JsonElement element) {
        if (element.isJsonObject()) {
            return this.handle((JsonObject)element);
        }
        return null;
    }

    protected TextureData handle(JsonObject object) {
        TextureJsonProcessor.ensureValuesExist(object, "domain", "name", "key", "type");
        String domain = object.get("domain").getAsString();
        String name = object.get("name").getAsString();
        String key = object.get("key").getAsString();
        String typeKey = object.get("type").getAsString();
        TextureData.Type type = TextureData.Type.get(typeKey);
        if (type == null) {
            throw new IllegalArgumentException("Invalid texture type '" + typeKey + "' while loading ");
        }
        return new TextureData(this, key, domain, name, type);
    }
}

