/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.client.json.render.processor;

import com.builtbroken.mc.client.json.imp.IRenderState;
import com.builtbroken.mc.client.json.render.RenderData;
import com.builtbroken.mc.client.json.render.processor.BlockStateJsonProcessor;
import com.builtbroken.mc.client.json.render.processor.ItemStateJsonProcessor;
import com.builtbroken.mc.client.json.render.processor.ModelStateJsonProcessor;
import com.builtbroken.mc.client.json.render.processor.RenderJsonSubProcessor;
import com.builtbroken.mc.client.json.render.tile.TileRenderData;
import com.builtbroken.mc.framework.json.processors.JsonProcessor;
import com.builtbroken.mc.framework.json.struct.JsonForLoop;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RenderJsonProcessor
extends JsonProcessor<RenderData> {
    public static final List<RenderJsonSubProcessor> stateProcessors = new ArrayList<RenderJsonSubProcessor>();
    private final HashMap<IRenderState, RenderJsonSubProcessor> stateToProcessor = new HashMap();

    @Override
    public String getMod() {
        return "voltzengine";
    }

    @Override
    public String getJsonKey() {
        return "render";
    }

    @Override
    public String getLoadOrder() {
        return null;
    }

    @Override
    public RenderData process(JsonElement element) {
        JsonArray array;
        RenderData data;
        JsonObject renderDataJSON = element.getAsJsonObject();
        RenderJsonProcessor.ensureValuesExist(renderDataJSON, "contentID", "states", "type");
        String contentID = renderDataJSON.get("contentID").getAsString();
        String overAllRenderType = renderDataJSON.get("type").getAsString();
        if (overAllRenderType.equalsIgnoreCase("tile")) {
            data = new TileRenderData(this, contentID, overAllRenderType);
            if (renderDataJSON.has("tileClass")) {
                try {
                    ((TileRenderData)data).tileClass = Class.forName(renderDataJSON.get("tileClass").getAsString());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to load class for name '" + renderDataJSON.get("tileClass").getAsString() + "'");
                }
            }
        } else {
            data = new RenderData(this, contentID, overAllRenderType);
        }
        if (renderDataJSON.has("renderLayers")) {
            data.setItemLayers(renderDataJSON.get("renderLayers").getAsInt());
        }
        if (renderDataJSON.has("renderLayerByState")) {
            array = renderDataJSON.getAsJsonArray("renderLayerByState");
            for (JsonElement arrayEntry : array) {
                JsonObject object = arrayEntry.getAsJsonObject();
                int meta = object.get("meta").getAsInt();
                int layers = object.get("layers").getAsInt();
                data.setItemLayers(meta, layers);
            }
        }
        array = renderDataJSON.get("states").getAsJsonArray();
        for (JsonElement arrayElement : array) {
            if (!(arrayElement instanceof JsonObject)) continue;
            JsonObject renderStateObject = arrayElement.getAsJsonObject();
            ArrayList<JsonObject> elements = new ArrayList<JsonObject>();
            if (renderStateObject.has("for")) {
                renderStateObject = renderStateObject.getAsJsonObject("for");
                JsonForLoop.generateDataForLoop(renderStateObject, elements, new HashMap<String, String>(), 0);
            } else if (renderStateObject.has("forEach")) {
                renderStateObject = renderStateObject.getAsJsonObject("forEach");
                JsonForLoop.generateDataForEachLoop(renderStateObject, elements, new HashMap<String, String>(), 0);
            }
            if (!elements.isEmpty()) {
                for (JsonObject stateElement : elements) {
                    this.handle(stateElement, data, overAllRenderType);
                }
                continue;
            }
            this.handle(renderStateObject, data, overAllRenderType);
        }
        for (IRenderState state : data.renderStatesByName.values()) {
            if (!this.stateToProcessor.containsKey(state)) continue;
            this.stateToProcessor.get(state).postHandle(state, data);
        }
        this.stateToProcessor.clear();
        return data;
    }

    protected void handle(JsonObject renderStateObject, RenderData data, String overAllRenderType) {
        IRenderState renderState = null;
        RenderJsonProcessor.ensureValuesExist(renderStateObject, "id");
        JsonPrimitive stateIDElement = renderStateObject.getAsJsonPrimitive("id");
        String stateID = stateIDElement.getAsString();
        String subType = overAllRenderType;
        if (renderStateObject.has("renderType")) {
            subType = renderStateObject.get("renderType").getAsString();
        }
        for (RenderJsonSubProcessor processor : stateProcessors) {
            if (!processor.canProcess(subType) || (renderState = (IRenderState)processor.process(renderStateObject, stateID, overAllRenderType, subType)) == null) continue;
            this.stateToProcessor.put(renderState, processor);
            processor.process(renderState, renderStateObject);
            break;
        }
        if (renderState == null) {
            throw new RuntimeException("Failed to process render state for StateID[" + stateID + "] SubRenderType[" + subType + "] RenderType[" + overAllRenderType + "]");
        }
        data.add(stateID, renderState);
    }

    static {
        stateProcessors.add(new BlockStateJsonProcessor());
        stateProcessors.add(new ModelStateJsonProcessor());
        stateProcessors.add(new ItemStateJsonProcessor());
    }
}

