/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.client.json.render.processor;

import com.builtbroken.mc.client.json.render.processor.RenderJsonSubProcessor;
import com.builtbroken.mc.client.json.render.state.ModelState;
import com.builtbroken.mc.client.json.render.tile.RenderStateTile;
import com.builtbroken.mc.client.json.texture.TextureData;
import com.builtbroken.mc.framework.json.conversion.data.transform.JsonConverterPos;
import com.builtbroken.mc.imp.transform.rotation.EulerAngle;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;

public class ModelStateJsonProcessor
extends RenderJsonSubProcessor<ModelState> {
    public ModelStateJsonProcessor() {
        super(TextureData.Type.MODEL);
    }

    @Override
    public ModelState process(JsonObject renderStateObject, String stateID, String globalRenderType, String subRenderType) {
        String modelID = null;
        Pos offset = null;
        Pos scale = null;
        EulerAngle rotation = null;
        if (renderStateObject.has("modelID")) {
            modelID = renderStateObject.get("modelID").getAsString();
        }
        if (renderStateObject.has("offset") && (offset = JsonConverterPos.fromJson(renderStateObject.get("offset"))) == null) {
            throw new IllegalArgumentException("Unknown value type for offset " + renderStateObject.get("offset"));
        }
        if (renderStateObject.has("scale") && (scale = JsonConverterPos.fromJson(renderStateObject.get("scale"))) == null) {
            throw new IllegalArgumentException("Unknown value type for scale " + renderStateObject.get("scale"));
        }
        if (renderStateObject.has("rotation")) {
            JsonObject rotationObject = renderStateObject.get("rotation").getAsJsonObject();
            double yaw = 0.0;
            double pitch = 0.0;
            double roll = 0.0;
            if (rotationObject.has("yaw")) {
                yaw = rotationObject.getAsJsonPrimitive("yaw").getAsDouble();
            }
            if (rotationObject.has("pitch")) {
                pitch = rotationObject.getAsJsonPrimitive("pitch").getAsDouble();
            }
            if (rotationObject.has("roll")) {
                roll = rotationObject.getAsJsonPrimitive("roll").getAsDouble();
            }
            rotation = new EulerAngle(yaw, pitch, roll);
        }
        ModelState renderState = globalRenderType.equalsIgnoreCase("tile") ? new RenderStateTile(stateID, modelID, offset, scale, rotation) : new ModelState(stateID, modelID, offset, scale, rotation);
        if (renderStateObject.has("rotationOrder")) {
            int i;
            ArrayList<String> rotations = new ArrayList<String>();
            JsonArray array = renderStateObject.getAsJsonArray("rotationOrder");
            for (i = 0; i < array.size(); ++i) {
                String value;
                JsonElement e = array.get(i);
                if (e.isJsonPrimitive()) {
                    value = e.getAsString().toLowerCase();
                    if (!(value.equalsIgnoreCase("yaw") || value.equalsIgnoreCase("pitch") || value.equalsIgnoreCase("roll") || value.equalsIgnoreCase("-yaw") || value.equalsIgnoreCase("-pitch") || value.equalsIgnoreCase("-roll"))) {
                        throw new IllegalArgumentException("Rotations order values can only be one of the follow {yaw, pitch, roll}");
                    }
                } else {
                    throw new IllegalArgumentException("Rotations value must be a string containing yaw, pitch, or roll.");
                }
                rotations.add(value);
            }
            if (rotations.size() > 3) {
                throw new IllegalArgumentException("Only 3 rotations can be applied, used parented objects to apply more.");
            }
            renderState.rotationOrder = new String[rotations.size()];
            for (i = 0; i < rotations.size(); ++i) {
                renderState.rotationOrder[i] = (String)rotations.get(i);
            }
        }
        if (renderStateObject.has("renderOnlyParts")) {
            renderState.renderOnlyParts = renderStateObject.get("renderOnlyParts").getAsBoolean();
        }
        if (renderStateObject.has("combineRotations")) {
            renderState.combineRotations = renderStateObject.get("combineRotations").getAsBoolean();
        }
        if (renderStateObject.has("renderParent")) {
            renderState.renderParent = renderStateObject.get("renderParent").getAsBoolean();
        }
        if (renderStateObject.has("parts")) {
            JsonElement partsElement = renderStateObject.get("parts");
            if (partsElement.isJsonArray()) {
                JsonArray array = partsElement.getAsJsonArray();
                ArrayList<String> parts = new ArrayList<String>();
                for (JsonElement element : array) {
                    if (element.isJsonPrimitive()) {
                        parts.add(element.getAsString());
                        continue;
                    }
                    if (element.isJsonObject() && element.getAsJsonObject().has("for")) {
                        JsonObject object = element.getAsJsonObject().getAsJsonObject("for");
                        ModelStateJsonProcessor.ensureValuesExist(object, "start", "end", "part");
                        int start = object.getAsJsonPrimitive("start").getAsInt();
                        int end = object.getAsJsonPrimitive("end").getAsInt();
                        if (start >= end) {
                            throw new IllegalArgumentException("Start can not be greater than or equal to end for a for loop.");
                        }
                        JsonPrimitive template = object.getAsJsonPrimitive("part");
                        for (int i = start; i <= end; ++i) {
                            parts.add(template.getAsString().replace("%number%", "" + i));
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid json data for parts array, input must be a string or for loop object.");
                }
                renderState.parts = new String[parts.size()];
                for (int i = 0; i < parts.size(); ++i) {
                    renderState.parts[i] = (String)parts.get(i);
                }
            } else if (partsElement.isJsonPrimitive()) {
                String parts = partsElement.getAsString();
                if (!parts.equals("all")) {
                    renderState.parts = parts.split(",");
                }
            } else {
                throw new IllegalArgumentException("Invalid json type for model parts, support types are string and string array");
            }
        }
        return renderState;
    }

    @Override
    public boolean canProcess(String type) {
        return type.equalsIgnoreCase("model");
    }
}

