/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.client.json.effects;

import com.builtbroken.mc.client.effects.VisualEffectProvider;
import com.builtbroken.mc.client.effects.VisualEffectRegistry;
import com.builtbroken.mc.client.json.ClientDataHandler;
import com.builtbroken.mc.client.json.imp.IEffectData;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import com.builtbroken.mc.framework.json.loading.JsonProcessorData;
import com.builtbroken.mc.framework.json.processors.JsonGenData;
import com.builtbroken.mc.imp.transform.rotation.EulerAngle;
import com.builtbroken.mc.imp.transform.vector.Pos;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EffectLayer
extends JsonGenData
implements IEffectData {
    public final String key;
    public final String effectKey;
    private NBTTagCompound nbt;
    private Pos renderOffset = Pos.zero;
    private static EulerAngle angle = new EulerAngle(0.0, 0.0);

    public EffectLayer(IJsonProcessor processor, String key, String effectKey) {
        super(processor);
        this.key = key.toLowerCase();
        this.effectKey = effectKey.toLowerCase();
    }

    @Override
    public void onCreated() {
        ClientDataHandler.INSTANCE.addEffect(this.key, this);
    }

    @Override
    public String getContentID() {
        return this.key;
    }

    @Override
    public String getUniqueID() {
        return this.key;
    }

    @Override
    public void trigger(World world, double x, double y, double z, double mx, double my, double mz, boolean endPoint) {
        this.trigger(world, x, y, z, mx, my, mz, endPoint, this.getNbt());
    }

    @Override
    public void trigger(World world, double x, double y, double z, double mx, double my, double mz, boolean endPoint, NBTTagCompound nbt) {
        VisualEffectProvider provider = VisualEffectRegistry.main.get(this.effectKey);
        if (provider != null) {
            Pos renderOffset;
            NBTTagCompound usedNBT;
            if (nbt != null && !nbt.func_82582_d()) {
                usedNBT = (NBTTagCompound)nbt.func_74737_b();
                if (this.getNbt() != null) {
                    for (Object o : this.getNbt().func_150296_c()) {
                        if (!(o instanceof String)) continue;
                        String key = (String)o;
                        NBTBase tag = this.getNbt().func_74781_a(key);
                        if (tag == null) continue;
                        usedNBT.func_74782_a(key, tag);
                    }
                }
            } else {
                usedNBT = this.getNbt() != null ? nbt : new NBTTagCompound();
            }
            if ((renderOffset = this.renderOffset) != Pos.zero && (usedNBT.func_74764_b("yaw") || usedNBT.func_74764_b("pitch"))) {
                float yaw = usedNBT.func_74760_g("yaw");
                float pitch = usedNBT.func_74760_g("pitch");
                angle.set(yaw, pitch, 0.0);
                renderOffset = (Pos)angle.transform(renderOffset);
            }
            provider.displayEffect(world, x + renderOffset.x(), y + renderOffset.y(), z + renderOffset.z(), mx, my, mz, endPoint, usedNBT);
        } else {
            Engine.logger().error("Failed to find a visual effect provider for key '" + this.effectKey + "'");
        }
    }

    @Override
    public NBTTagCompound getNbt() {
        return this.nbt;
    }

    @JsonProcessorData(value={"additionalEffectData"}, type="nbt")
    public void setNbt(NBTTagCompound nbt) {
        this.nbt = nbt;
    }

    public Pos getRenderOffset() {
        return this.renderOffset;
    }

    @JsonProcessorData(value={"renderOffset"}, type="pos")
    public void setRenderOffset(Pos renderOffset) {
        this.renderOffset = renderOffset;
    }

    public String toString() {
        return "EffectData[ " + this.key + ", " + this.effectKey + "]@" + this.hashCode();
    }
}

