/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.client;

import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.explosive.ITexturedExplosiveHandler;
import com.builtbroken.mc.api.items.explosives.IExplosiveContainerItem;
import com.builtbroken.mc.client.json.ClientDataHandler;
import com.builtbroken.mc.client.json.imp.IRenderState;
import com.builtbroken.mc.client.json.render.RenderData;
import com.builtbroken.mc.client.json.render.state.RenderStateTexture;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.explosive.ExplosiveRegistry;
import com.builtbroken.mc.framework.json.imp.IJsonKeyDataProvider;
import com.builtbroken.mc.lib.data.item.ItemStackWrapper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.TextureStitchEvent;

public class ExplosiveRegistryClient {
    public static final int renderPassesForItem = 4;
    public static final HashMap<ItemStackWrapper, IIcon> EX_CORNER_ICONS = new HashMap();
    public static final HashMap<ItemStackWrapper, String> EX_CORNER_RESOURCES = new HashMap();
    @SideOnly(value=Side.CLIENT)
    public static IIcon missing_corner_icon;
    public static HashMap<Integer, EntityList.EntityEggInfo> entityIDToEgg;

    public static void mapEntityIDsToEggs() {
        entityIDToEgg.clear();
        for (EntityList.EntityEggInfo entityegginfo : EntityList.field_75627_a.values()) {
            if (entityegginfo == null) continue;
            entityIDToEgg.put(entityegginfo.field_75613_a, entityegginfo);
        }
    }

    public static EntityList.EntityEggInfo getEggInfo(int id) {
        if (entityIDToEgg.isEmpty()) {
            ExplosiveRegistryClient.mapEntityIDsToEggs();
        }
        return entityIDToEgg.get(id);
    }

    public static IIcon getCornerIconFor(ItemStack stack, int pass) {
        ItemStack item = stack;
        if (item.func_77973_b() instanceof IExplosiveContainerItem) {
            item = ((IExplosiveContainerItem)item.func_77973_b()).getExplosiveStack(stack);
        }
        if (item != null) {
            ItemStackWrapper wrapper;
            IExplosiveHandler handler = ExplosiveRegistry.get(item);
            if (handler != null) {
                IIcon icon;
                if (handler instanceof ITexturedExplosiveHandler && (icon = ((ITexturedExplosiveHandler)handler).getBottomLeftCornerIcon(item, pass)) != null) {
                    return icon;
                }
                String contentID = handler.getID();
                RenderData data = ClientDataHandler.INSTANCE.getRenderData(handler.getMod() + ":" + contentID);
                if (data != null && data.renderType.equalsIgnoreCase("ex")) {
                    List<String> keys = ExplosiveRegistryClient.getStatesForCornerIcon(stack, handler, pass);
                    for (String key : keys) {
                        IRenderState state = data.getState(key);
                        if (state == null || !(state instanceof RenderStateTexture)) continue;
                        return state.getIcon(0);
                    }
                }
            }
            if (EX_CORNER_ICONS.containsKey(wrapper = new ItemStackWrapper(item))) {
                return EX_CORNER_ICONS.get(wrapper);
            }
        }
        return missing_corner_icon;
    }

    public static int getColorForCornerIcon(ItemStack stack, int pass) {
        IExplosiveHandler handler;
        ItemStack item = stack;
        if (item.func_77973_b() instanceof IExplosiveContainerItem) {
            item = ((IExplosiveContainerItem)item.func_77973_b()).getExplosiveStack(stack);
        }
        if (item != null && (handler = ExplosiveRegistry.get(item)) != null) {
            if (handler instanceof ITexturedExplosiveHandler) {
                return ((ITexturedExplosiveHandler)handler).getBottomLeftCornerIconColor(item, pass);
            }
            String contentID = handler.getID();
            RenderData data = ClientDataHandler.INSTANCE.getRenderData(handler.getMod() + ":" + contentID);
            if (data != null && data.renderType.equalsIgnoreCase("ex")) {
                List<String> keys = ExplosiveRegistryClient.getStatesForCornerIcon(stack, handler, pass);
                for (String key : keys) {
                    String colorKey;
                    IRenderState state = data.getState(key);
                    if (state == null || !(state instanceof RenderStateTexture) || (colorKey = ((RenderStateTexture)state).color) == null || colorKey.isEmpty()) continue;
                    if (colorKey.startsWith("data@")) {
                        if (!(handler instanceof IJsonKeyDataProvider)) continue;
                        Object object = ((IJsonKeyDataProvider)((Object)handler)).getJsonKeyData(colorKey.substring(5, colorKey.length()), stack);
                        if (object instanceof Integer) {
                            return (Integer)object;
                        }
                        if (!(object instanceof Color)) continue;
                        return ((Color)object).getRGB();
                    }
                    if (!ClientDataHandler.INSTANCE.canSupportColor(colorKey)) continue;
                    return ClientDataHandler.INSTANCE.getColorAsInt(colorKey);
                }
            }
        }
        return 0xFFFFFF;
    }

    public static List<String> getStatesForCornerIcon(ItemStack stack, IExplosiveHandler handler, int pass) {
        ArrayList<String> keys = new ArrayList<String>();
        String stateOne = handler.getStateID(stack);
        if (stateOne != null && !stateOne.isEmpty()) {
            keys.add("ex.corner." + handler.getStateID(stack) + "." + pass);
            keys.add("ex.corner." + handler.getStateID(stack));
        }
        keys.add("ex.corner." + pass);
        keys.add("ex.corner");
        return keys;
    }

    public static void registerIcon(ItemStack item, String resource) {
        ItemStackWrapper wrapper = new ItemStackWrapper(item);
        if (!EX_CORNER_RESOURCES.containsKey(wrapper)) {
            EX_CORNER_RESOURCES.put(wrapper, resource);
        } else {
            Engine.logger().error("Something attempt to register an existing resource location for loading ex icons", (Throwable)new RuntimeException());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onStitch(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 0) {
            for (IExplosiveHandler iExplosiveHandler : ExplosiveRegistry.getExplosives()) {
                if (!(iExplosiveHandler instanceof ITexturedExplosiveHandler)) continue;
                ((ITexturedExplosiveHandler)iExplosiveHandler).registerExplosiveHandlerIcons((IIconRegister)event.map, true);
            }
        } else if (event.map.func_130086_a() == 1) {
            for (IExplosiveHandler iExplosiveHandler : ExplosiveRegistry.getExplosives()) {
                if (!(iExplosiveHandler instanceof ITexturedExplosiveHandler)) continue;
                ((ITexturedExplosiveHandler)iExplosiveHandler).registerExplosiveHandlerIcons((IIconRegister)event.map, false);
            }
            EX_CORNER_ICONS.clear();
            for (Map.Entry entry : EX_CORNER_RESOURCES.entrySet()) {
                EX_CORNER_ICONS.put((ItemStackWrapper)entry.getKey(), event.map.func_94245_a((String)entry.getValue()));
            }
            missing_corner_icon = event.map.func_94245_a("voltzengine:ex.icon.missing");
        }
    }

    static {
        entityIDToEgg = new HashMap();
    }
}

