/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.intermod;

import exterminatorjeff.undergroundbiomes.api.API;
import exterminatorjeff.undergroundbiomes.api.common.IUBOreConfig;
import exterminatorjeff.undergroundbiomes.api.common.UBLogger;
import exterminatorjeff.undergroundbiomes.api.common.UBOresRegistry;
import exterminatorjeff.undergroundbiomes.client.UBStateMappers;
import exterminatorjeff.undergroundbiomes.common.block.UBOre;
import exterminatorjeff.undergroundbiomes.common.block.UBOreIgneous;
import exterminatorjeff.undergroundbiomes.common.block.UBOreMetamorphic;
import exterminatorjeff.undergroundbiomes.common.block.UBOreSedimentary;
import exterminatorjeff.undergroundbiomes.common.block.UBStone;
import exterminatorjeff.undergroundbiomes.config.UBConfig;
import exterminatorjeff.undergroundbiomes.core.UndergroundBiomes;
import exterminatorjeff.undergroundbiomes.intermod.OreEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public enum OresRegistry implements UBOresRegistry
{
    INSTANCE;

    private static final UBLogger LOGGER;
    private final String SETUP_ERROR_MSG = "Cannot setup UBOres for '%s', Underground Biomes's block registering has not started yet!";
    private final String SETUP_INFO_MSG = "The ore '%s' has been successfully UBfied.";
    private final String REQUEST_ERROR_MSG = "Cannot request UBOres setup for '%s', Underground Biomes's block registering is done!";
    private final String REQUEST_INFO_MSG = "Request for '%s' to be UBfied added.";
    private boolean alreadySetup = false;
    private final Set<UBifyRequest> requests = new HashSet<UBifyRequest>();
    private final Map<String, OreEntry> ubifiedOres = new HashMap<String, OreEntry>();
    private final Map<String, ArrayList<String>> oreDirectories = new HashMap<String, ArrayList<String>>();
    private final Map<String, ResourceLocation> oresToOverlays = new HashMap<String, ResourceLocation>();
    private final HashMap<Integer, HashMap<ChunkPos, ArrayList<BlockPos>>> storedLocations = new HashMap();

    private String format(String message, Block baseOre) {
        return String.format(message, baseOre.getRegistryName());
    }

    private String format(String message, Block baseOre, int meta) {
        return String.format(message, baseOre.getRegistryName() + ":" + meta);
    }

    private String toKey(Block baseOre, int baseOreMeta, Block baseStone) {
        if (baseOreMeta == -1) {
            baseOreMeta = 0;
        }
        return baseOre.getRegistryName() + ":" + baseOreMeta + ":" + baseStone.getRegistryName();
    }

    public boolean isUBified(Block baseStone, IBlockState baseOreState) {
        if (!UBConfig.SPECIFIC.ubifyOres()) {
            return false;
        }
        Block baseOre = baseOreState.func_177230_c();
        int baseOreMeta = baseOre.func_176201_c(baseOreState);
        boolean result = this.ubifiedOres.containsKey(this.toKey(baseOre, baseOreMeta, baseStone));
        return result;
    }

    public IBlockState getUBifiedOre(UBStone baseStone, int baseStoneMeta, IBlockState baseOreState) {
        Block baseOre = baseOreState.func_177230_c();
        int baseOreMeta = baseOre.func_176201_c(baseOreState);
        return this.ubifiedOres.get(this.toKey(baseOre, baseOreMeta, baseStone)).ore().func_176203_a(baseStoneMeta);
    }

    private void applyBaseOreSmelting(Block baseOre, int meta, OreEntry ... ores) {
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(baseOre, 1, meta));
        if (result != null && result.func_77973_b() != new ItemStack(Blocks.field_150350_a).func_77973_b()) {
            for (OreEntry ore : ores) {
                for (int i = 0; i < ore.ore().getNbVariants(); ++i) {
                    GameRegistry.addSmelting((ItemStack)new ItemStack(ore.getBlock(), 1, i), (ItemStack)result, (float)FurnaceRecipes.func_77602_a().func_151398_b(result));
                }
            }
        }
    }

    @Override
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        for (UBifyRequest request : this.requests) {
            Block baseOre = request.baseOre;
            int baseOreMeta = request.baseOreMeta;
            request.getIgneousOreEntry().registerBlock(event, new UBOreIgneous(baseOre, request.config));
            request.getMetamorphicOreEntry().registerBlock(event, new UBOreMetamorphic(baseOre, request.config));
            request.getSedimentraryOreEntry().registerBlock(event, new UBOreSedimentary(baseOre, request.config));
            API.REGISTERED_ORES.add(request.getIgneousOreEntry().ore());
            API.REGISTERED_ORES.add(request.getMetamorphicOreEntry().ore());
            API.REGISTERED_ORES.add(request.getSedimentraryOreEntry().ore());
            this.ubifiedOres.put(this.toKey(baseOre, baseOreMeta, API.IGNEOUS_STONE.getBlock()), request.getIgneousOreEntry());
            this.ubifiedOres.put(this.toKey(baseOre, baseOreMeta, API.METAMORPHIC_STONE.getBlock()), request.getMetamorphicOreEntry());
            this.ubifiedOres.put(this.toKey(baseOre, baseOreMeta, API.SEDIMENTARY_STONE.getBlock()), request.getSedimentraryOreEntry());
        }
    }

    @Override
    public void registerItems(RegistryEvent.Register<Item> event) {
        for (UBifyRequest request : this.requests) {
            request.getIgneousOreEntry().registerItem(event, new UBOreIgneous(request.baseOre, request.config));
            request.getMetamorphicOreEntry().registerItem(event, new UBOreMetamorphic(request.baseOre, request.config));
            request.getSedimentraryOreEntry().registerItem(event, new UBOreSedimentary(request.baseOre, request.config));
        }
    }

    @Override
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        for (UBifyRequest request : this.requests) {
            this.applyBaseOreSmelting(request.baseOre, request.baseOreMeta, request.getIgneousOreEntry(), request.getMetamorphicOreEntry(), request.getSedimentraryOreEntry());
        }
    }

    @Override
    public void requestOreSetup(Block baseOre, IUBOreConfig config) {
        if (UndergroundBiomes.areBlocksAlreadyRegistered || this.alreadySetup) {
            throw new RuntimeException(this.format("Cannot request UBOres setup for '%s', Underground Biomes's block registering is done!", baseOre, config.getMeta()));
        }
        this.requests.add(new UBifyRequest(baseOre, config));
        LOGGER.debug(this.format("Request for '%s' to be UBfied added.", baseOre, config.getMeta()));
    }

    public ItemStack getUBOresTabIcon() {
        Random random = new Random();
        Object[] ores = this.ubifiedOres.values().toArray();
        UBOre ore = ((OreEntry)ores[random.nextInt(ores.length)]).ore();
        return new ItemStack(Item.func_150898_a((Block)ore), 1, random.nextInt(ore.getNbVariants()));
    }

    private String toKey(Block baseOre, int baseOreMeta) {
        if (baseOreMeta == -1) {
            baseOreMeta = 0;
        }
        return baseOre.getRegistryName() + "." + baseOreMeta;
    }

    private ResourceLocation getOverlayFor(String key) {
        ResourceLocation location = this.oresToOverlays.get(key);
        if (location == null) {
            LOGGER.error("There is no registered overlay for '" + key + "'!");
        }
        return location;
    }

    public ResourceLocation getOverlayFor(Block baseOre) {
        return this.getOverlayFor(this.toKey(baseOre, -1));
    }

    public ResourceLocation getOverlayFor(Block baseOre, int baseOreMeta) {
        return this.getOverlayFor(this.toKey(baseOre, baseOreMeta));
    }

    private void registerOreOverlay(String key, ResourceLocation overlayLocation) {
        if (!this.oresToOverlays.containsKey(key)) {
            this.oresToOverlays.put(key, overlayLocation);
        } else {
            LOGGER.warn("An overlay for '" + key + "' has already been registered!");
        }
    }

    @Override
    public void registerOreOverlay(Block baseOre, ResourceLocation overlayLocation) {
        this.registerOreOverlay(this.toKey(baseOre, -1), overlayLocation);
    }

    @Override
    public void registerOreOverlay(Block baseOre, int baseOreMeta, ResourceLocation overlayLocation) {
        this.registerOreOverlay(this.toKey(baseOre, baseOreMeta), overlayLocation);
    }

    public void registerOreModels() {
        this.ubifiedOres.values().forEach(oreEntry -> oreEntry.registerModel(UBStateMappers.UBORE_STATE_MAPPER));
    }

    public void copyOreDictionaries() {
        for (OreEntry oreEntry : this.ubifiedOres.values()) {
            this.copyOreDictionary(oreEntry);
        }
    }

    private void copyOreDictionary(OreEntry oreEntry) {
        Block block = oreEntry.getBlock();
        Block baseOre = oreEntry.ore().baseOre;
        int baseOreMeta = oreEntry.ore().baseOreMeta;
        ItemStack baseOreStack = null;
        baseOreStack = baseOreMeta == -1 ? new ItemStack(baseOre, 1) : new ItemStack(baseOre, 1, baseOreMeta);
        int[] registrationIDs = OreDictionary.getOreIDs((ItemStack)baseOreStack);
        for (int i = 0; i < registrationIDs.length; ++i) {
            String registrationName = OreDictionary.getOreName((int)registrationIDs[i]);
            this.registerOreDirctionary(registrationName, block);
        }
        for (String oreDictionary : oreEntry.ore().config.getOreDirectories()) {
            this.registerOreDirctionary(oreDictionary, block);
        }
    }

    private void registerOreDirctionary(String oreDictName, Block block) {
        for (int j = 0; j < 8; ++j) {
            ItemStack stack = new ItemStack(block, 1, j);
            OreDictionary.registerOre((String)oreDictName, (ItemStack)stack);
        }
    }

    @SubscribeEvent
    public void registerOverlayTextures(TextureStitchEvent.Pre e) {
        this.oresToOverlays.values().forEach(overlayLocation -> e.getMap().func_174942_a(overlayLocation));
    }

    private int dimension(IBlockAccess access) {
        return ((World)access).field_73011_w.getDimension();
    }

    private final ArrayList<BlockPos> blockPosList(IBlockAccess world, ChunkPos chunkID) {
        ArrayList<Object> result;
        int dimension = this.dimension(world);
        HashMap<Object, ArrayList<Object>> worldMap = this.storedLocations.get(dimension);
        if (worldMap == null) {
            worldMap = new HashMap();
            this.storedLocations.put(dimension, worldMap);
        }
        if ((result = worldMap.get(chunkID)) == null) {
            result = new ArrayList();
            worldMap.put(chunkID, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecheck(IBlockAccess world, BlockPos pos) {
        HashMap<Integer, HashMap<ChunkPos, ArrayList<BlockPos>>> hashMap = this.storedLocations;
        synchronized (hashMap) {
            ChunkPos chunkID = new ChunkPos(pos);
            this.blockPosList(world, chunkID).add(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<ChunkPos, ArrayList<BlockPos>> forRedo(IBlockAccess world) {
        HashMap<Object, ArrayList<Object>> result = null;
        HashMap<Integer, HashMap<ChunkPos, ArrayList<BlockPos>>> hashMap = this.storedLocations;
        synchronized (hashMap) {
            int dimension = this.dimension(world);
            result = this.storedLocations.get(dimension);
            if (result == null) {
                result = new HashMap();
            }
            this.storedLocations.remove(dimension);
        }
        return result;
    }

    public void recheckPile() {
        int result = 0;
        for (Integer world : this.storedLocations.keySet()) {
            int worldResult = 0;
            HashMap<ChunkPos, ArrayList<BlockPos>> chunkPosMap = this.storedLocations.get(world);
            for (ChunkPos chunkPos : chunkPosMap.keySet()) {
                worldResult += chunkPosMap.get(chunkPos).size();
            }
            result += worldResult;
            System.out.println("" + worldResult + " Blocks in World : " + world.toString());
        }
        System.out.println("Blocks queued for redo: " + result);
    }

    static {
        LOGGER = new UBLogger(OresRegistry.class, Level.INFO);
    }

    private class UBifyRequest {
        protected final Block baseOre;
        protected final int baseOreMeta;
        protected OreEntry igneousOreEntry;
        protected OreEntry metamorphicOreEntry;
        protected OreEntry sedimentraryOreEntry;
        protected IUBOreConfig config;

        UBifyRequest(Block baseOre, IUBOreConfig config) {
            if (baseOre == null) {
                throw new RuntimeException();
            }
            this.baseOre = baseOre;
            this.baseOreMeta = config.getMeta();
            this.config = config;
        }

        public OreEntry getIgneousOreEntry() {
            if (this.igneousOreEntry == null) {
                this.igneousOreEntry = new OreEntry(API.IGNEOUS_STONE.getBlock(), this.baseOre, this.baseOreMeta);
            }
            return this.igneousOreEntry;
        }

        public OreEntry getMetamorphicOreEntry() {
            if (this.metamorphicOreEntry == null) {
                this.metamorphicOreEntry = new OreEntry(API.METAMORPHIC_STONE.getBlock(), this.baseOre, this.baseOreMeta);
            }
            return this.metamorphicOreEntry;
        }

        public OreEntry getSedimentraryOreEntry() {
            if (this.sedimentraryOreEntry == null) {
                this.sedimentraryOreEntry = new OreEntry(API.SEDIMENTARY_STONE.getBlock(), this.baseOre, this.baseOreMeta);
            }
            return this.sedimentraryOreEntry;
        }
    }
}

