/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.common.block.wall;

import exterminatorjeff.undergroundbiomes.api.names.BlockEntry;
import exterminatorjeff.undergroundbiomes.client.UBCreativeTab;
import exterminatorjeff.undergroundbiomes.common.UBSubBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class UBStoneWall
extends BlockWall
implements UBSubBlock {
    private final ItemBlock itemBlock = new UBItemWall(this);

    public UBStoneWall(BlockEntry baseStoneEntry) {
        super(baseStoneEntry.getBlock());
        this.func_149647_a(UBCreativeTab.UB_BLOCKS_TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176256_a, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176254_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176257_M, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176258_N, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176259_O, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Block toBlock() {
        return this;
    }

    @Override
    public ItemBlock getItemBlock() {
        return this.itemBlock;
    }

    protected abstract BlockStateContainer func_180661_e();

    public int func_176201_c(IBlockState state) {
        return this.baseStone().func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < this.getNbVariants(); ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public String func_149732_F() {
        return I18n.func_74838_a((String)(this.func_149739_a() + ".name"));
    }

    private boolean canConnectTo(IBlockAccess worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof UBStoneWall || block instanceof BlockWall) {
            return true;
        }
        if (block == Blocks.field_180401_cv) {
            return false;
        }
        if (block != this && !(block instanceof BlockFenceGate)) {
            if (state.func_185904_a().func_76218_k() && state.func_185917_h()) {
                return state.func_185904_a() != Material.field_151572_C;
            }
            return false;
        }
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean north = this.canConnectTo(worldIn, pos.func_177978_c());
        boolean east = this.canConnectTo(worldIn, pos.func_177974_f());
        boolean south = this.canConnectTo(worldIn, pos.func_177968_d());
        boolean west = this.canConnectTo(worldIn, pos.func_177976_e());
        boolean straight = north && !east && south && !west || !north && east && !south && west;
        return state.func_177226_a((IProperty)field_176256_a, (Comparable)Boolean.valueOf(!straight || !worldIn.func_175623_d(pos.func_177984_a()))).func_177226_a((IProperty)field_176254_b, (Comparable)Boolean.valueOf(north)).func_177226_a((IProperty)field_176257_M, (Comparable)Boolean.valueOf(east)).func_177226_a((IProperty)field_176258_N, (Comparable)Boolean.valueOf(south)).func_177226_a((IProperty)field_176259_O, (Comparable)Boolean.valueOf(west));
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    private class UBItemWall
    extends ItemBlock {
        public UBItemWall(UBStoneWall block) {
            super((Block)block);
            this.func_77656_e(0);
            this.func_77627_a(true);
        }

        public int func_77647_b(int damage) {
            return damage;
        }

        public String func_77657_g(ItemStack stack) {
            return super.func_77657_g(stack) + "." + UBStoneWall.this.getVariantName(stack.func_77960_j());
        }
    }
}

