/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.core;

import exterminatorjeff.undergroundbiomes.api.UBDimensionalStrataColumnProvider;
import exterminatorjeff.undergroundbiomes.api.UBStrataColumn;
import exterminatorjeff.undergroundbiomes.api.UBStrataColumnProvider;
import exterminatorjeff.undergroundbiomes.config.ConfigManager;
import exterminatorjeff.undergroundbiomes.config.UBConfig;
import exterminatorjeff.undergroundbiomes.world.WorldGenManager;
import java.io.File;
import java.util.HashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.PropertyManager;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DimensionManager
implements UBDimensionalStrataColumnProvider {
    public HashMap<Integer, WorldGenManager> managers = new HashMap();
    private boolean villageRegistered = false;
    private boolean oreRegistered = false;
    private ConfigManager configManager;
    private final UBStrataColumnProvider vanillaColumnProvider = new UBStrataColumnProvider(){

        @Override
        public UBStrataColumn strataColumn(int x, int z) {
            return DimensionManager.this.vanillaColumn;
        }
    };
    private final UBStrataColumn vanillaColumn = new UBStrataColumn(){

        @Override
        public IBlockState stone(int height) {
            return Blocks.field_150348_b.func_176223_P();
        }

        @Override
        public IBlockState cobblestone(int height) {
            return Blocks.field_150347_e.func_176223_P();
        }

        @Override
        public IBlockState stone() {
            return Blocks.field_150348_b.func_176223_P();
        }

        @Override
        public IBlockState cobblestone() {
            return Blocks.field_150347_e.func_176223_P();
        }
    };

    public DimensionManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public void refreshManagers() {
        this.managers = new HashMap();
        if (UBConfig.SPECIFIC.ubifyVillages() && !this.villageRegistered) {
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
            this.villageRegistered = true;
        }
        if (!UBConfig.SPECIFIC.ubifyVillages() && this.villageRegistered) {
            MinecraftForge.TERRAIN_GEN_BUS.unregister((Object)this);
            this.villageRegistered = false;
        }
        if (UBConfig.SPECIFIC.disableVanillaStoneVariants() && !this.oreRegistered) {
            MinecraftForge.ORE_GEN_BUS.register((Object)this);
            this.oreRegistered = true;
        }
        if (!UBConfig.SPECIFIC.disableVanillaStoneVariants() && this.oreRegistered) {
            MinecraftForge.ORE_GEN_BUS.unregister((Object)this);
            this.oreRegistered = false;
        }
        ((UBConfig)UBConfig.SPECIFIC).getUBifiedDimensions().forEach(dimensionID -> {
            WorldGenManager manager = new WorldGenManager((int)dimensionID);
            MinecraftForge.EVENT_BUS.register((Object)manager);
            this.managers.put((Integer)dimensionID, manager);
        });
    }

    public void serverLoad(MinecraftServer server) {
        if (server == null) {
            return;
        }
        File worldSaveDirectory = null;
        String worldName = server.func_71270_I();
        if (server.func_71264_H()) {
            File saveDirectory = server.func_71209_f("saves");
            worldSaveDirectory = new File(saveDirectory, worldName);
        } else {
            PropertyManager settings = new PropertyManager(server.func_71209_f("server.properties"));
            worldName = settings.func_73671_a("level-name", worldName);
            worldSaveDirectory = server.func_71209_f(worldName);
        }
        WorldServer worldServer = server.func_71218_a(0);
        File worldLocation = worldServer.getChunkSaveLocation();
        this.configManager.setWorldFile(worldLocation);
        this.refreshManagers();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        int dimension;
        WorldGenManager target;
        if (this.managers.size() == 0) {
            this.serverLoad(event.getWorld().func_73046_m());
        }
        if ((target = this.managers.get(dimension = event.getWorld().field_73011_w.getDimension())) != null) {
            target.onWorldLoad(event);
        }
    }

    @SubscribeEvent
    public void onPopulateChunkPost(PopulateChunkEvent.Post event) {
        int dimension = event.getWorld().field_73011_w.getDimension();
        WorldGenManager target = this.managers.get(dimension);
        if (target != null) {
            target.onPopulateChunkPost(event);
        }
    }

    @SubscribeEvent
    public void onGenerateMinable(OreGenEvent.GenerateMinable event) {
        int dimension = event.getWorld().field_73011_w.getDimension();
        WorldGenManager target = this.managers.get(dimension);
        if (target != null) {
            target.onGenerateMinable(event);
        }
    }

    @SubscribeEvent
    public void initMapGen(InitMapGenEvent event) {
        WorldGenManager target = this.managers.get(0);
        if (target != null) {
            target.initMapGen(event);
        }
    }

    public void clearWorldManagers() {
        this.managers = new HashMap();
    }

    @Override
    public UBStrataColumnProvider ubStrataColumnProvider(int dimension) {
        WorldGenManager manager = this.managers.get(dimension);
        if (manager == null) {
            return this.vanillaColumnProvider;
        }
        return manager;
    }
}

