/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.sound;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModSounds {
    public static SoundEvent ENGINE_STOP = ModSounds.registerSound("engine_stop");
    public static SoundEvent ENGINE_STARTING = ModSounds.registerSound("engine_starting");
    public static SoundEvent ENGINE_START = ModSounds.registerSound("engine_start");
    public static SoundEvent ENGINE_IDLE = ModSounds.registerSound("engine_idle");
    public static SoundEvent ENGINE_HIGH = ModSounds.registerSound("engine_high");
    public static SoundEvent CRASH = ModSounds.registerSound("crash");
    public static SoundEvent RATCHET = ModSounds.registerSound("ratchet");

    public static List<SoundEvent> getAll() {
        ArrayList<SoundEvent> sounds = new ArrayList<SoundEvent>();
        for (Field field : ModSounds.class.getFields()) {
            try {
                Object obj = field.get(null);
                if (!(obj instanceof SoundEvent)) continue;
                sounds.add((SoundEvent)obj);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return sounds;
    }

    public static SoundEvent registerSound(String soundName) {
        SoundEvent event = new SoundEvent(new ResourceLocation("plane", soundName));
        event.setRegistryName(new ResourceLocation("plane", soundName));
        return event;
    }

    public static void playSound(SoundEvent evt, Level world, BlockPos pos, Player entity, SoundSource category, float volume) {
        ModSounds.playSound(evt, world, pos, entity, category, volume, 1.0f);
    }

    public static void playSound(SoundEvent evt, Level world, BlockPos pos, Player entity, SoundSource category, float volume, float pitch) {
        if (entity != null) {
            world.m_5594_(entity, pos, evt, category, volume, pitch);
        } else if (!world.f_46443_) {
            world.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, evt, category, volume, pitch);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSoundLoop(AbstractTickableSoundInstance loop, Level world) {
        if (world.f_46443_) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)loop);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSoundLoopDelayed(AbstractTickableSoundInstance loop, Level world, int delay) {
        if (world.f_46443_) {
            Minecraft.m_91087_().m_91106_().m_120369_((SoundInstance)loop, delay);
        }
    }
}

